/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.bytes;

import io.netty.buffer.ByteBuf;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000bJ\u0018\u0010\u000f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u000bH\u0007J\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\u000e\u001a\u00020\u000bJ\u0016\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000bJ\u001e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000bJ\u001e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ldorkbox/bytes/OptimizeUtilsByteBuf;", "", "()V", "version", "", "canReadInt", "", "buffer", "Lio/netty/buffer/ByteBuf;", "canReadLong", "canReadVarInt", "", "intLength", "value", "optimizePositive", "longLength", "", "readInt", "readLong", "writeInt", "writeLong", "ByteUtilities"})
public final class OptimizeUtilsByteBuf {
    @NotNull
    public static final OptimizeUtilsByteBuf INSTANCE = new OptimizeUtilsByteBuf();
    @NotNull
    public static final String version = "2.0";

    private OptimizeUtilsByteBuf() {
    }

    public final int intLength(int value, boolean optimizePositive) {
        int value2 = value;
        if (!optimizePositive) {
            value2 = value2 << 1 ^ value2 >> 31;
        }
        if (value2 >>> 7 == 0) {
            return 1;
        }
        if (value2 >>> 14 == 0) {
            return 2;
        }
        if (value2 >>> 21 == 0) {
            return 3;
        }
        return value2 >>> 28 == 0 ? 4 : 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int canReadInt(@NotNull ByteBuf buffer) {
        int n;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int startIndex = buffer.readerIndex();
        try {
            int remaining = buffer.readableBytes();
            int offset = 0;
            int count = 1;
            while (offset < 32 && remaining > 0) {
                byte b = buffer.readByte();
                if ((b & 0x80) == 0) {
                    int n2 = count;
                    return n2;
                }
                offset += 7;
                --remaining;
                ++count;
            }
            n = 0;
        }
        finally {
            buffer.readerIndex(startIndex);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean canReadVarInt(@NotNull ByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int startIndex = buffer.readerIndex();
        try {
            int remaining = buffer.readableBytes();
            if (remaining >= 5) {
                boolean bl = true;
                return bl;
            }
            int p = startIndex;
            if ((buffer.getByte(p++) & 0x80) == 0) {
                boolean bl = true;
                return bl;
            }
            if (p == remaining) {
                boolean bl = false;
                return bl;
            }
            if ((buffer.getByte(p++) & 0x80) == 0) {
                boolean bl = true;
                return bl;
            }
            if (p == remaining) {
                boolean bl = false;
                return bl;
            }
            if ((buffer.getByte(p++) & 0x80) == 0) {
                boolean bl = true;
                return bl;
            }
            if (p == remaining) {
                boolean bl = false;
                return bl;
            }
            if ((buffer.getByte(p++) & 0x80) == 0) {
                boolean bl = true;
                return bl;
            }
            boolean bl = p != remaining;
            return bl;
        }
        finally {
            buffer.readerIndex(startIndex);
        }
    }

    public final int readInt(@NotNull ByteBuf buffer, boolean optimizePositive) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        byte b = buffer.readByte();
        int result = b & 0x7F;
        if ((b & 0x80) != 0) {
            b = buffer.readByte();
            result |= (b & 0x7F) << 7;
            if ((b & 0x80) != 0) {
                b = buffer.readByte();
                result |= (b & 0x7F) << 14;
                if ((b & 0x80) != 0) {
                    b = buffer.readByte();
                    result |= (b & 0x7F) << 21;
                    if ((b & 0x80) != 0) {
                        b = buffer.readByte();
                        result |= (b & 0x7F) << 28;
                    }
                }
            }
        }
        return optimizePositive ? result : result >>> 1 ^ -(result & 1);
    }

    public static /* synthetic */ int readInt$default(OptimizeUtilsByteBuf optimizeUtilsByteBuf, ByteBuf byteBuf, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return optimizeUtilsByteBuf.readInt(byteBuf, bl);
    }

    public final int writeInt(@NotNull ByteBuf buffer, int value, boolean optimizePositive) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int value2 = value;
        if (!optimizePositive) {
            value2 = value2 << 1 ^ value2 >> 31;
        }
        if (value2 >>> 7 == 0) {
            buffer.writeByte((int)((byte)value2));
            return 1;
        }
        if (value2 >>> 14 == 0) {
            buffer.writeByte((int)((byte)(value2 & 0x7F | 0x80)));
            buffer.writeByte((int)((byte)(value2 >>> 7)));
            return 2;
        }
        if (value2 >>> 21 == 0) {
            buffer.writeByte((int)((byte)(value2 & 0x7F | 0x80)));
            buffer.writeByte((int)((byte)(value2 >>> 7 | 0x80)));
            buffer.writeByte((int)((byte)(value2 >>> 14)));
            return 3;
        }
        if (value2 >>> 28 == 0) {
            buffer.writeByte((int)((byte)(value2 & 0x7F | 0x80)));
            buffer.writeByte((int)((byte)(value2 >>> 7 | 0x80)));
            buffer.writeByte((int)((byte)(value2 >>> 14 | 0x80)));
            buffer.writeByte((int)((byte)(value2 >>> 21)));
            return 4;
        }
        buffer.writeByte((int)((byte)(value2 & 0x7F | 0x80)));
        buffer.writeByte((int)((byte)(value2 >>> 7 | 0x80)));
        buffer.writeByte((int)((byte)(value2 >>> 14 | 0x80)));
        buffer.writeByte((int)((byte)(value2 >>> 21 | 0x80)));
        buffer.writeByte((int)((byte)(value2 >>> 28)));
        return 5;
    }

    @JvmStatic
    public static final int longLength(long value, boolean optimizePositive) {
        long value2 = value;
        if (!optimizePositive) {
            value2 = value2 << 1 ^ value2 >> 63;
        }
        if (value2 >>> 7 == 0L) {
            return 1;
        }
        if (value2 >>> 14 == 0L) {
            return 2;
        }
        if (value2 >>> 21 == 0L) {
            return 3;
        }
        if (value2 >>> 28 == 0L) {
            return 4;
        }
        if (value2 >>> 35 == 0L) {
            return 5;
        }
        if (value2 >>> 42 == 0L) {
            return 6;
        }
        if (value2 >>> 49 == 0L) {
            return 7;
        }
        return value2 >>> 56 == 0L ? 8 : 9;
    }

    public final long readLong(@NotNull ByteBuf buffer, boolean optimizePositive) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        byte b = buffer.readByte();
        long result = b & 0x7F;
        if ((b & 0x80) != 0) {
            b = buffer.readByte();
            result |= (long)((b & 0x7F) << 7);
            if ((b & 0x80) != 0) {
                b = buffer.readByte();
                result |= (long)((b & 0x7F) << 14);
                if ((b & 0x80) != 0) {
                    b = buffer.readByte();
                    result |= (long)((b & 0x7F) << 21);
                    if ((b & 0x80) != 0) {
                        b = buffer.readByte();
                        result |= (long)(b & 0x7F) << 28;
                        if ((b & 0x80) != 0) {
                            b = buffer.readByte();
                            result |= (long)(b & 0x7F) << 35;
                            if ((b & 0x80) != 0) {
                                b = buffer.readByte();
                                result |= (long)(b & 0x7F) << 42;
                                if ((b & 0x80) != 0) {
                                    b = buffer.readByte();
                                    result |= (long)(b & 0x7F) << 49;
                                    if ((b & 0x80) != 0) {
                                        b = buffer.readByte();
                                        result |= (long)b << 56;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (!optimizePositive) {
            result = result >>> 1 ^ -(result & 1L);
        }
        return result;
    }

    public final int writeLong(@NotNull ByteBuf buffer, long value, boolean optimizePositive) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        long value2 = value;
        if (!optimizePositive) {
            value2 = value2 << 1 ^ value2 >> 63;
        }
        if (value2 >>> 7 == 0L) {
            buffer.writeByte((int)((byte)value2));
            return 1;
        }
        if (value2 >>> 14 == 0L) {
            buffer.writeByte((int)((byte)(value2 & 0x7FL | 0x80L)));
            buffer.writeByte((int)((byte)(value2 >>> 7)));
            return 2;
        }
        if (value2 >>> 21 == 0L) {
            buffer.writeByte((int)((byte)(value2 & 0x7FL | 0x80L)));
            buffer.writeByte((int)((byte)(value2 >>> 7 | 0x80L)));
            buffer.writeByte((int)((byte)(value2 >>> 14)));
            return 3;
        }
        if (value2 >>> 28 == 0L) {
            buffer.writeByte((int)((byte)(value2 & 0x7FL | 0x80L)));
            buffer.writeByte((int)((byte)(value2 >>> 7 | 0x80L)));
            buffer.writeByte((int)((byte)(value2 >>> 14 | 0x80L)));
            buffer.writeByte((int)((byte)(value2 >>> 21)));
            return 4;
        }
        if (value2 >>> 35 == 0L) {
            buffer.writeByte((int)((byte)(value2 & 0x7FL | 0x80L)));
            buffer.writeByte((int)((byte)(value2 >>> 7 | 0x80L)));
            buffer.writeByte((int)((byte)(value2 >>> 14 | 0x80L)));
            buffer.writeByte((int)((byte)(value2 >>> 21 | 0x80L)));
            buffer.writeByte((int)((byte)(value2 >>> 28)));
            return 5;
        }
        if (value2 >>> 42 == 0L) {
            buffer.writeByte((int)((byte)(value2 & 0x7FL | 0x80L)));
            buffer.writeByte((int)((byte)(value2 >>> 7 | 0x80L)));
            buffer.writeByte((int)((byte)(value2 >>> 14 | 0x80L)));
            buffer.writeByte((int)((byte)(value2 >>> 21 | 0x80L)));
            buffer.writeByte((int)((byte)(value2 >>> 28 | 0x80L)));
            buffer.writeByte((int)((byte)(value2 >>> 35)));
            return 6;
        }
        if (value2 >>> 49 == 0L) {
            buffer.writeByte((int)((byte)(value2 & 0x7FL | 0x80L)));
            buffer.writeByte((int)((byte)(value2 >>> 7 | 0x80L)));
            buffer.writeByte((int)((byte)(value2 >>> 14 | 0x80L)));
            buffer.writeByte((int)((byte)(value2 >>> 21 | 0x80L)));
            buffer.writeByte((int)((byte)(value2 >>> 28 | 0x80L)));
            buffer.writeByte((int)((byte)(value2 >>> 35 | 0x80L)));
            buffer.writeByte((int)((byte)(value2 >>> 42)));
            return 7;
        }
        if (value2 >>> 56 == 0L) {
            buffer.writeByte((int)((byte)(value2 & 0x7FL | 0x80L)));
            buffer.writeByte((int)((byte)(value2 >>> 7 | 0x80L)));
            buffer.writeByte((int)((byte)(value2 >>> 14 | 0x80L)));
            buffer.writeByte((int)((byte)(value2 >>> 21 | 0x80L)));
            buffer.writeByte((int)((byte)(value2 >>> 28 | 0x80L)));
            buffer.writeByte((int)((byte)(value2 >>> 35 | 0x80L)));
            buffer.writeByte((int)((byte)(value2 >>> 42 | 0x80L)));
            buffer.writeByte((int)((byte)(value2 >>> 49)));
            return 8;
        }
        buffer.writeByte((int)((byte)(value2 & 0x7FL | 0x80L)));
        buffer.writeByte((int)((byte)(value2 >>> 7 | 0x80L)));
        buffer.writeByte((int)((byte)(value2 >>> 14 | 0x80L)));
        buffer.writeByte((int)((byte)(value2 >>> 21 | 0x80L)));
        buffer.writeByte((int)((byte)(value2 >>> 28 | 0x80L)));
        buffer.writeByte((int)((byte)(value2 >>> 35 | 0x80L)));
        buffer.writeByte((int)((byte)(value2 >>> 42 | 0x80L)));
        buffer.writeByte((int)((byte)(value2 >>> 49 | 0x80L)));
        buffer.writeByte((int)((byte)(value2 >>> 56)));
        return 9;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int canReadLong(@NotNull ByteBuf buffer) {
        int n;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int position = buffer.readerIndex();
        try {
            int remaining = buffer.readableBytes();
            int offset = 0;
            int count = 1;
            while (offset < 64 && remaining > 0) {
                byte b = buffer.readByte();
                if ((b & 0x80) == 0) {
                    int n2 = count;
                    return n2;
                }
                offset += 7;
                --remaining;
                ++count;
            }
            n = 0;
        }
        finally {
            buffer.readerIndex(position);
        }
        return n;
    }
}

