/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.parser.antlr;

import de.peeeq.wurstscript.antlr.WurstLexer;
import de.peeeq.wurstscript.attributes.CompilationUnitInfo;
import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.parser.WPos;
import de.peeeq.wurstscript.utils.LineOffsets;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Stack;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenFactory;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.misc.Pair;
import org.eclipse.jdt.annotation.Nullable;

public class ExtendedWurstLexer
implements TokenSource {
    private final WurstLexer orig;
    private final Queue<Token> nextTokens = new LinkedList<Token>();
    private State state = State.INIT;
    private final Stack<Integer> indentationLevels = new Stack();
    private int spacesPerIndent = -1;
    private @Nullable Token eof = null;
    private Token firstNewline;
    private int numberOfTabs;
    private final LineOffsets lineOffsets = new LineOffsets();
    private final boolean debug = false;
    private final Pair<TokenSource, CharStream> sourcePair;
    private boolean isWurst = false;
    private boolean lastCharWasWrap = false;
    private @Nullable Token lastToken = null;
    private TabChoice tabChoice = TabChoice.Unknown;
    private CompileError tabWarning = null;
    private int parenthesesLevel = 0;
    private final Deque<Token> commentTokens = new ArrayDeque<Token>();

    public Deque<Token> getCommentTokens() {
        return this.commentTokens;
    }

    public ExtendedWurstLexer(CharStream input) {
        this.orig = new WurstLexer(input);
        this.sourcePair = new Pair((Object)this.orig, (Object)input);
        this.indentationLevels.push(0);
    }

    public int getCharPositionInLine() {
        return this.orig.getCharPositionInLine();
    }

    public CharStream getInputStream() {
        return this.orig.getInputStream();
    }

    public int getLine() {
        return this.orig.getLine();
    }

    public String getSourceName() {
        return this.orig.getSourceName();
    }

    public TokenFactory<?> getTokenFactory() {
        return this.orig.getTokenFactory();
    }

    public Token nextToken() {
        Token t;
        this.lastToken = t = this.nextTokenIntern();
        return t;
    }

    private Token nextTokenIntern() {
        if (!this.nextTokens.isEmpty()) {
            return this.nextTokens.poll();
        }
        Token l_eof = this.eof;
        if (l_eof != null) {
            return this.makeToken(-1, "$EOF", l_eof.getStartIndex(), l_eof.getStopIndex());
        }
        while (true) {
            Token token;
            Token token1;
            if ((token1 = this.orig.nextToken()) == null) {
                continue;
            }
            if (token1.getChannel() == 2) {
                this.commentTokens.addLast(token1);
                continue;
            }
            if (this.isWurst) {
                if (this.isJassOnlyKeyword(token1)) {
                    token1 = this.makeToken(127, token1.getText(), token1.getStartIndex(), token1.getStopIndex());
                    assert (token1 != null);
                } else if (token1.getType() == 15) {
                    this.handleIndent(0, token1, token1.getStartIndex(), token1.getStopIndex(), token1);
                    this.isWurst = false;
                }
            } else if (token1.getType() == 14) {
                this.isWurst = true;
            } else if (this.isWurstOnlyKeyword(token1)) {
                token1 = this.makeToken(127, token1.getText(), token1.getStartIndex(), token1.getStopIndex());
                assert (token1 != null);
            } else if (token1.getType() == 135) continue;
            if ((token = token1).getType() == 126) {
                int line = 0;
                for (int i = 0; i < token.getText().length(); ++i) {
                    char c = token.getText().charAt(i);
                    if (c != '\n') continue;
                    this.lineOffsets.set(token.getLine() + line, token.getStartIndex() + i);
                    ++line;
                }
            } else if (token.getType() == 103) {
                ++this.parenthesesLevel;
            } else if (token.getType() == 104) {
                --this.parenthesesLevel;
            } else if (token.getType() == -1) {
                this.handleIndent(0, token, token.getStartIndex(), token.getStopIndex(), token);
                this.eof = token;
                if (this.isWurst) {
                    this.nextTokens.add(this.makeToken(15, "endpackage", token.getStartIndex(), token.getStopIndex()));
                    this.nextTokens.add(this.makeToken(126, "$NL", token.getStartIndex(), token.getStopIndex()));
                }
                this.lineOffsets.set(token.getLine(), token.getStopIndex() + 1);
                return this.makeToken(126, "$NL", token.getStartIndex(), token.getStopIndex());
            }
            switch (this.state) {
                case INIT: {
                    if (token.getType() == 126) {
                        if (this.lastCharWasWrap) break;
                        this.firstNewline = token;
                        this.state(State.NEWLINES);
                        break;
                    }
                    if (this.isTab(token)) break;
                    this.lastCharWasWrap = this.isWrapCharEndLine(token.getType());
                    return token;
                }
                case NEWLINES: {
                    if (this.isWrapCharBeginLine(token.getType())) {
                        this.lastCharWasWrap = this.isWrapChar(token.getType());
                        this.state(State.INIT);
                        return token;
                    }
                    if (token.getType() == 126) break;
                    if (this.isTab(token)) {
                        this.state(State.BEGIN_LINE);
                        this.readTabChar(token);
                        this.numberOfTabs = this.tabWidth(token);
                        break;
                    }
                    this.handleIndent(0, token, token.getStartIndex(), token.getStopIndex(), this.firstNewline);
                    this.nextTokens.add(token);
                    this.state(State.INIT);
                    return this.firstNewline;
                }
                case BEGIN_LINE: {
                    if (this.isTab(token)) {
                        this.readTabChar(token);
                        this.numberOfTabs += this.tabWidth(token);
                        break;
                    }
                    if (token.getType() == 126) {
                        this.state(State.NEWLINES);
                        break;
                    }
                    if (this.isWrapCharBeginLine(token.getType())) {
                        this.lastCharWasWrap = this.isWrapChar(token.getType());
                        this.state(State.INIT);
                        return token;
                    }
                    if (this.lastCharWasWrap && this.numberOfTabs > this.indentationLevels.peek()) {
                        this.state(State.INIT);
                        return token;
                    }
                    this.handleIndent(this.numberOfTabs, token, token.getStartIndex(), token.getStopIndex(), this.firstNewline);
                    this.state(State.INIT);
                    this.nextTokens.add(token);
                    return this.firstNewline;
                }
            }
        }
    }

    private int tabWidth(Token token) {
        int len = 1 + token.getStopIndex() - token.getStartIndex();
        switch (token.getType()) {
            case 132: {
                return len * 4;
            }
            case 133: {
                return len;
            }
        }
        throw new IllegalArgumentException();
    }

    private void readTabChar(Token token) {
        if (this.tabChoice == TabChoice.Unknown) {
            this.tabChoice = TabChoice.from(token);
        } else if (this.tabWarning == null) {
            if (token.getType() == 132) {
                if (this.tabChoice == TabChoice.Spaces) {
                    this.tabWarning = new CompileError(new WPos("", this.lineOffsets, token.getStartIndex(), token.getStopIndex()), "Mixing tabs and spaces for indentation.");
                }
            } else if (token.getType() == 133 && this.tabChoice == TabChoice.Tabs && this.tabWidth(token) > 3) {
                this.tabWarning = new CompileError(new WPos("", this.lineOffsets, token.getStartIndex(), token.getStopIndex()), "Mixing tabs and spaces for indentation.");
            }
        }
    }

    private boolean isTab(Token token) {
        return token.getType() == 132 || token.getType() == 133;
    }

    private boolean isWurstOnlyKeyword(Token token) {
        switch (token.getType()) {
            case 54: 
            case 62: {
                return true;
            }
        }
        return false;
    }

    private boolean isJassOnlyKeyword(Token token) {
        switch (token.getType()) {
            case 86: 
            case 88: 
            case 89: 
            case 124: {
                return true;
            }
        }
        return false;
    }

    private void state(State s) {
        this.state = s;
    }

    private void handleIndent(int n, Token token, int start, int stop, Token endBlockToken) {
        if (!this.isWurst) {
            return;
        }
        if (n > this.indentationLevels.peek()) {
            if (this.spacesPerIndent < 0) {
                this.spacesPerIndent = n;
            } else if (this.parenthesesLevel == 0 && this.tabWarning == null && n != this.indentationLevels.peek() + this.spacesPerIndent) {
                String message = "Inconsistent indentation: Earlier in this file " + this.spacesPerIndent + " spaces were used for indentation and here it is " + (n - this.indentationLevels.peek()) + " spaces.";
                this.tabWarning = new CompileError(new WPos("", this.lineOffsets, this.lineOffsets.get(token.getLine()), token.getStopIndex()), message);
            }
            if (this.tabWarning == null && n % 2 == 1) {
                this.tabWarning = new CompileError(new WPos("", this.lineOffsets, this.lineOffsets.get(token.getLine()), token.getStopIndex()), "Use an even number of spaces for indentation.");
            }
            this.indentationLevels.push(n);
            this.nextTokens.add(this.makeToken(119, "$begin", start, stop));
        } else {
            while (n < this.indentationLevels.peek()) {
                this.indentationLevels.pop();
                this.nextTokens.add(this.makeToken(120, "$end", endBlockToken.getStartIndex(), endBlockToken.getStartIndex()));
            }
            Integer expectedIndentation = this.indentationLevels.peek();
            if (n != expectedIndentation && token.getType() != 70) {
                String msg = "Invalid indentation level. Current indentation is " + expectedIndentation + ", but this is indented by " + n + ".";
                for (ANTLRErrorListener el : this.orig.getErrorListeners()) {
                    int line = this.lineOffsets.getLine(start);
                    el.syntaxError((Recognizer)this.orig, (Object)"", line, start - this.lineOffsets.get(line), msg, null);
                }
            }
        }
    }

    private void reportError(int line, int charPositionInLine, String msg) {
        for (ANTLRErrorListener el : this.orig.getErrorListeners()) {
            el.syntaxError((Recognizer)this.orig, (Object)"", line, charPositionInLine, msg, null);
        }
    }

    private boolean isWrapChar(int type) {
        switch (type) {
            case 38: 
            case 39: 
            case 52: 
            case 53: 
            case 91: 
            case 92: 
            case 94: 
            case 96: 
            case 97: 
            case 98: 
            case 101: 
            case 102: {
                return true;
            }
        }
        return false;
    }

    private boolean isWrapCharEndLine(int type) {
        switch (type) {
            case 103: 
            case 105: {
                return true;
            }
        }
        return this.isWrapChar(type);
    }

    private boolean isWrapCharBeginLine(int type) {
        switch (type) {
            case 69: 
            case 99: 
            case 100: 
            case 104: 
            case 106: {
                return true;
            }
        }
        return this.isWrapChar(type);
    }

    private Token makeToken(int type, String text, int start, int stop) {
        Pair<TokenSource, CharStream> source = this.sourcePair;
        int channel = 0;
        CommonToken t = new CommonToken(source, type, channel, start, stop);
        return t;
    }

    public void setTokenFactory(TokenFactory<?> factory) {
        this.orig.setTokenFactory(factory);
    }

    public LineOffsets getLineOffsets() {
        return this.lineOffsets;
    }

    public void setErrorListener(ANTLRErrorListener listener) {
        this.orig.removeErrorListeners();
        this.orig.addErrorListener(listener);
    }

    public CompileError getTabWarning() {
        return this.tabWarning;
    }

    public CompilationUnitInfo.IndentationMode getIndentationMode() {
        if (this.tabChoice == TabChoice.Tabs) {
            return CompilationUnitInfo.IndentationMode.tabs();
        }
        int num = this.spacesPerIndent;
        if (num < 0) {
            num = 4;
        }
        return CompilationUnitInfo.IndentationMode.spaces(num);
    }

    static enum TabChoice {
        Unknown,
        Spaces,
        Tabs;


        public static TabChoice from(Token token) {
            if (token.getType() == 133) {
                return Spaces;
            }
            return Tabs;
        }
    }

    static enum State {
        INIT,
        NEWLINES,
        BEGIN_LINE;

    }
}

