/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.attributes;

import de.peeeq.wurstscript.ast.AstElementWithSource;
import de.peeeq.wurstscript.ast.ClassDef;
import de.peeeq.wurstscript.ast.ConstructorDef;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.ExprClosure;
import de.peeeq.wurstscript.ast.ExprFunctionCall;
import de.peeeq.wurstscript.ast.ExprMemberMethod;
import de.peeeq.wurstscript.ast.ExprMemberVar;
import de.peeeq.wurstscript.ast.ExprNewObject;
import de.peeeq.wurstscript.ast.ExtensionFuncDef;
import de.peeeq.wurstscript.ast.FuncDef;
import de.peeeq.wurstscript.ast.FuncRef;
import de.peeeq.wurstscript.ast.FunctionCall;
import de.peeeq.wurstscript.ast.Identifier;
import de.peeeq.wurstscript.ast.InitBlock;
import de.peeeq.wurstscript.ast.LoopStatement;
import de.peeeq.wurstscript.ast.NameDef;
import de.peeeq.wurstscript.ast.OnDestroyDef;
import de.peeeq.wurstscript.ast.SomeSuperConstructorCall;
import de.peeeq.wurstscript.ast.StmtIf;
import de.peeeq.wurstscript.ast.StmtLoop;
import de.peeeq.wurstscript.ast.StmtWhile;
import de.peeeq.wurstscript.ast.StructureDef;
import de.peeeq.wurstscript.ast.SwitchStmt;
import de.peeeq.wurstscript.ast.VarDef;
import de.peeeq.wurstscript.ast.WImport;
import de.peeeq.wurstscript.ast.WImports;
import de.peeeq.wurstscript.ast.WPackage;
import de.peeeq.wurstscript.parser.WPos;
import de.peeeq.wurstscript.utils.LineOffsets;
import org.eclipse.jdt.annotation.Nullable;

public class AttrPos {
    public static WPos getPos(Element e) {
        if (e instanceof AstElementWithSource) {
            AstElementWithSource ws = (AstElementWithSource)e;
            return ws.getSource();
        }
        if (e.size() > 0) {
            int min = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            for (int i = 0; i < e.size(); ++i) {
                Element child = e.get(i);
                WPos childSource = child.attrSource();
                if (childSource.getRightPos() < childSource.getLeftPos()) continue;
                min = Math.min(min, childSource.getLeftPos());
                max = Math.max(max, childSource.getRightPos());
            }
            return new WPos(e.get(0).attrSource().getFile(), e.get(0).attrSource().getLineOffsets(), min, max);
        }
        return AttrPos.getParentSource(e);
    }

    public static WPos getPos(WImports e) {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (WImport i : e) {
            if (i.getPackagename().equals("Wurst")) continue;
            WPos childSource = i.getSource();
            min = Math.min(min, childSource.getLeftPos());
            max = Math.max(max, childSource.getRightPos());
        }
        if (min != Integer.MAX_VALUE) {
            return new WPos(((WImport)e.get(0)).attrSource().getFile(), ((WImport)e.get(0)).attrSource().getLineOffsets(), min, max);
        }
        return AttrPos.getParentSource(e);
    }

    private static WPos getParentSource(Element e) {
        for (Element parent = e.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof AstElementWithSource)) continue;
            WPos parentSource = ((AstElementWithSource)parent).getSource();
            return new WPos(parentSource.getFile(), parentSource.getLineOffsets(), parentSource.getLeftPos(), parentSource.getLeftPos() - 1);
        }
        return new WPos("<source of " + e + " not found>", new LineOffsets(), 0, -1);
    }

    private static @Nullable LineOffsets getLineOffsets(WPos p) {
        LineOffsets lineOffsets = p.getLineOffsets() instanceof LineOffsets ? p.getLineOffsets() : new LineOffsets();
        return lineOffsets;
    }

    public static WPos getErrorPos(Element e) {
        return e.attrSource();
    }

    public static WPos getErrorPos(SomeSuperConstructorCall e) {
        return e.getKeywordSource();
    }

    public static WPos getErrorPos(WPackage e) {
        return AttrPos.identifierPos(e, e.getNameId());
    }

    public static WPos getErrorPos(NameDef e) {
        return AttrPos.identifierPos(e, e.getNameId());
    }

    public static WPos getErrorPos(FuncDef e) {
        return AttrPos.identifierPos(e, e.getNameId());
    }

    public static WPos getErrorPos(ExtensionFuncDef e) {
        return AttrPos.identifierPos(e, e.getNameId());
    }

    public static WPos getErrorPos(ClassDef e) {
        return AttrPos.identifierPos(e, e.getNameId());
    }

    public static WPos getErrorPos(ConstructorDef e) {
        WPos pos = e.getSource();
        return AttrPos.updateRight(pos, pos.getLeftPos() + "construct".length());
    }

    public static WPos getErrorPos(InitBlock e) {
        WPos pos = e.getSource();
        return AttrPos.updateRight(pos, pos.getLeftPos() + "init".length());
    }

    public static WPos getErrorPos(OnDestroyDef e) {
        WPos pos = e.getSource();
        return AttrPos.updateRight(pos, pos.getLeftPos() + "ondestroy".length());
    }

    public static WPos getErrorPos(StructureDef e) {
        return AttrPos.identifierPos(e, e.getNameId());
    }

    public static WPos getErrorPos(LoopStatement e) {
        WPos pos = e.getSource();
        return AttrPos.updateRight(pos, pos.getLeftPos() + 3);
    }

    public static WPos getErrorPos(StmtWhile e) {
        WPos pos = e.getSource();
        return AttrPos.updateRight(pos, pos.getLeftPos() + 5);
    }

    public static WPos getErrorPos(StmtLoop e) {
        WPos pos = e.getSource();
        return AttrPos.updateRight(pos, pos.getLeftPos() + 5);
    }

    public static WPos getErrorPos(StmtIf e) {
        WPos pos = e.getSource();
        return AttrPos.updateRight(pos, pos.getLeftPos() + 2);
    }

    public static WPos getErrorPos(SwitchStmt e) {
        WPos pos = e.getSource();
        return AttrPos.updateRight(pos, pos.getLeftPos() + 6);
    }

    public static WPos getErrorPos(FuncRef e) {
        return AttrPos.identifierPos(e, e.getFuncNameId());
    }

    private static WPos identifierPos(Element e, Identifier ident) {
        WPos childSource;
        Element child;
        int i;
        WPos source = ident.getSource();
        if (!source.isArtificial()) {
            return source;
        }
        WPos eSource = e.attrSource();
        int left = eSource.getLeftPos();
        int right = eSource.getRightPos();
        for (i = 0; i < e.size() && (child = e.get(i)) != ident; ++i) {
            childSource = child.attrSource();
            if (childSource.getRightPos() >= right) continue;
            left = Math.max(left, childSource.getRightPos());
        }
        for (i = e.size() - 1; i >= 0 && (child = e.get(i)) != ident; --i) {
            childSource = child.attrSource();
            if (childSource.getLeftPos() <= left) continue;
            right = Math.min(right, childSource.getLeftPos());
        }
        return source.withLeftPos(left).withRightPos(right);
    }

    public static WPos getErrorPos(FunctionCall e) {
        return AttrPos.identifierPos(e, e.getFuncNameId());
    }

    public static WPos getErrorPos(ExprMemberVar e) {
        return AttrPos.identifierPos(e, e.getVarNameId());
    }

    public static WPos getErrorPos(ExprMemberMethod e) {
        return AttrPos.identifierPos(e, e.getFuncNameId());
    }

    public static WPos getErrorPos(ExprFunctionCall e) {
        return AttrPos.identifierPos(e, e.getFuncNameId());
    }

    public static WPos getErrorPos(ExprClosure e) {
        return e.getArrowSource();
    }

    public static WPos getErrorPos(ExprNewObject e) {
        return AttrPos.identifierPos(e, e.getTypeNameId());
    }

    public static WPos getErrorPos(VarDef e) {
        return AttrPos.identifierPos(e, e.getNameId());
    }

    private static WPos updateRight(WPos pos, int newRight) {
        if (newRight > pos.getLeftPos()) {
            return pos.withRightPos(newRight);
        }
        return pos;
    }
}

