/*
 * Decompiled with CFR 0.152.
 */
package workers;

import javax.swing.SwingWorker;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import net.ConnectionManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ui.UiManager;
import workers.OnlineCheckWorker;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u000f\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0014\u00a2\u0006\u0002\u0010\rR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lworkers/OnlineCheckWorker;", "Ljavax/swing/SwingWorker;", "", "Ljava/lang/Void;", "url", "", "doneListener", "Lkotlin/Function0;", "", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "log", "Lmu/KLogger;", "doInBackground", "()Ljava/lang/Boolean;", "WurstSetup"})
public final class OnlineCheckWorker
extends SwingWorker<Boolean, Void> {
    @NotNull
    private final String url;
    @NotNull
    private final Function0<Unit> doneListener;
    @NotNull
    private final KLogger log;

    public OnlineCheckWorker(@NotNull String url, @NotNull Function0<Unit> doneListener) {
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(doneListener, "doneListener");
        this.url = url;
        this.doneListener = doneListener;
        this.log = KotlinLogging.INSTANCE.logger(log.1.INSTANCE);
    }

    @Override
    @Nullable
    protected Boolean doInBackground() throws Exception {
        this.log.debug("check connectivity");
        ConnectionManager.INSTANCE.checkConnectivity(this.url);
        UiManager.INSTANCE.refreshComponents();
        this.log.debug("check build");
        this.doneListener.invoke();
        return null;
    }
}

