/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport.sshd;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.internal.transport.sshd.AuthenticationCanceledException;
import org.eclipse.jgit.internal.transport.sshd.SshdText;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.sshd.KeyPasswordProvider;
import org.eclipse.jgit.util.StringUtils;

public class IdentityPasswordProvider
implements KeyPasswordProvider {
    private CredentialsProvider provider;
    private int attempts = 1;
    private final Map<URIish, State> current = new HashMap<URIish, State>();

    public IdentityPasswordProvider(CredentialsProvider provider) {
        this.provider = provider;
    }

    @Override
    public void setAttempts(int numberOfPasswordPrompts) {
        if (numberOfPasswordPrompts <= 0) {
            throw new IllegalArgumentException("Number of password prompts must be >= 1");
        }
        this.attempts = numberOfPasswordPrompts;
    }

    @Override
    public int getAttempts() {
        return Math.max(1, this.attempts);
    }

    @Override
    public char[] getPassphrase(URIish uri, int attempt) throws IOException {
        return this.getPassword(uri, attempt, this.current.computeIfAbsent(uri, r -> new State()));
    }

    protected char[] getPassword(URIish uri, int attempt, @NonNull State state) throws IOException {
        state.setPassword(null);
        state.incCount();
        String message = state.count == 1 ? SshdText.get().keyEncryptedMsg : SshdText.get().keyEncryptedRetry;
        char[] pass = this.getPassword(uri, MessageFormat.format(message, uri));
        state.setPassword(pass);
        return pass;
    }

    protected CredentialsProvider getCredentialsProvider() {
        return this.provider;
    }

    protected char[] getPassword(URIish uri, String message) {
        if (this.provider == null) {
            return null;
        }
        boolean haveMessage = !StringUtils.isEmptyOrNull(message);
        ArrayList<CredentialItem> items = new ArrayList<CredentialItem>(haveMessage ? 2 : 1);
        if (haveMessage) {
            items.add(new CredentialItem.InformationalMessage(message));
        }
        CredentialItem.Password password = new CredentialItem.Password(SshdText.get().keyEncryptedPrompt);
        items.add(password);
        try {
            boolean completed = this.provider.get(uri, items);
            char[] pass = password.getValue();
            if (!completed) {
                this.cancelAuthentication();
                return null;
            }
            char[] cArray = pass == null ? null : (char[])pass.clone();
            return cArray;
        }
        finally {
            password.clear();
        }
    }

    protected void cancelAuthentication() {
        throw new AuthenticationCanceledException();
    }

    protected boolean keyLoaded(URIish uri, State state, char[] password, Exception err) throws IOException, GeneralSecurityException {
        if (err == null || password == null) {
            return false;
        }
        if (state != null && state.getCount() < this.attempts) {
            return true;
        }
        if (err instanceof GeneralSecurityException) {
            throw new InvalidKeyException(MessageFormat.format(SshdText.get().identityFileCannotDecrypt, uri), err);
        }
        return false;
    }

    @Override
    public boolean keyLoaded(URIish uri, int attempt, Exception error) throws IOException, GeneralSecurityException {
        State state = null;
        boolean retry = false;
        try {
            state = this.current.get(uri);
            retry = this.keyLoaded(uri, state, state == null ? null : state.getPassword(), error);
        }
        finally {
            if (state != null) {
                state.setPassword(null);
            }
            if (!retry) {
                this.current.remove(uri);
            }
        }
        return retry;
    }

    protected static class State {
        private int count = 0;
        private char[] password;

        protected State() {
        }

        public int getCount() {
            return this.count;
        }

        public int incCount() {
            return ++this.count;
        }

        public void setPassword(char[] password) {
            if (this.password != null) {
                Arrays.fill(this.password, '\u0000');
            }
            this.password = (char[])(password != null ? (char[])password.clone() : null);
        }

        public char[] getPassword() {
            return this.password;
        }
    }
}

