/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jgit.api.errors.AbortedByHookException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.hooks.PrePushHook;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.PushConnection;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.TrackingRefUpdate;
import org.eclipse.jgit.transport.Transport;

class PushProcess {
    static final String PROGRESS_OPENING_CONNECTION = JGitText.get().openingConnection;
    private final Transport transport;
    private PushConnection connection;
    private final Map<String, RemoteRefUpdate> toPush;
    private final RevWalk walker;
    private final OutputStream out;
    private List<String> pushOptions;
    private final PrePushHook prePush;

    PushProcess(Transport transport, Collection<RemoteRefUpdate> toPush, PrePushHook prePush) throws TransportException {
        this(transport, toPush, prePush, null);
    }

    PushProcess(Transport transport, Collection<RemoteRefUpdate> toPush, PrePushHook prePush, OutputStream out) throws TransportException {
        this.walker = new RevWalk(transport.local);
        this.transport = transport;
        this.toPush = new LinkedHashMap<String, RemoteRefUpdate>();
        this.prePush = prePush;
        this.out = out;
        this.pushOptions = transport.getPushOptions();
        for (RemoteRefUpdate rru : toPush) {
            if (this.toPush.put(rru.getRemoteName(), rru) == null) continue;
            throw new TransportException(MessageFormat.format(JGitText.get().duplicateRemoteRefUpdateIsIllegal, rru.getRemoteName()));
        }
    }

    PushResult execute(ProgressMonitor monitor) throws NotSupportedException, TransportException {
        try {
            monitor.beginTask(PROGRESS_OPENING_CONNECTION, 0);
            PushResult res = new PushResult();
            this.connection = this.transport.openPush();
            try {
                res.setAdvertisedRefs(this.transport.getURI(), this.connection.getRefsMap());
                res.peerUserAgent = this.connection.getPeerUserAgent();
                monitor.endTask();
                Map<String, RemoteRefUpdate> expanded = this.expandMatching();
                this.toPush.clear();
                this.toPush.putAll(expanded);
                res.setRemoteUpdates(this.toPush);
                Map<String, RemoteRefUpdate> preprocessed = this.prepareRemoteUpdates();
                List<RemoteRefUpdate> willBeAttempted = preprocessed.values().stream().filter(u -> {
                    switch (u.getStatus()) {
                        case UP_TO_DATE: 
                        case REJECTED_NONFASTFORWARD: 
                        case REJECTED_NODELETE: 
                        case REJECTED_REMOTE_CHANGED: 
                        case REJECTED_OTHER_REASON: 
                        case NON_EXISTING: {
                            return false;
                        }
                    }
                    return true;
                }).collect(Collectors.toList());
                if (!willBeAttempted.isEmpty() && this.prePush != null) {
                    try {
                        this.prePush.setRefs(willBeAttempted);
                        this.prePush.setDryRun(this.transport.isDryRun());
                        this.prePush.call();
                    }
                    catch (IOException | AbortedByHookException e) {
                        throw new TransportException(e.getMessage(), e);
                    }
                }
                if (this.transport.isDryRun()) {
                    this.modifyUpdatesForDryRun();
                } else if (!preprocessed.isEmpty()) {
                    this.connection.push(monitor, preprocessed, this.out);
                }
            }
            finally {
                this.connection.close();
                res.addMessages(this.connection.getMessages());
            }
            if (!this.transport.isDryRun()) {
                this.updateTrackingRefs();
            }
            for (RemoteRefUpdate rru : this.toPush.values()) {
                TrackingRefUpdate tru = rru.getTrackingRefUpdate();
                if (tru == null) continue;
                res.add(tru);
            }
            PushResult pushResult = res;
            return pushResult;
        }
        finally {
            this.walker.close();
        }
    }

    private Map<String, RemoteRefUpdate> prepareRemoteUpdates() throws TransportException {
        boolean atomic = this.transport.isPushAtomic();
        LinkedHashMap<String, RemoteRefUpdate> result2 = new LinkedHashMap<String, RemoteRefUpdate>();
        for (RemoteRefUpdate rru : this.toPush.values()) {
            Ref advertisedRef = this.connection.getRef(rru.getRemoteName());
            ObjectId advertisedOld = null;
            if (advertisedRef != null) {
                advertisedOld = advertisedRef.getObjectId();
            }
            if (advertisedOld == null) {
                advertisedOld = ObjectId.zeroId();
            }
            if (rru.getNewObjectId().equals(advertisedOld)) {
                if (rru.isDelete()) {
                    rru.setStatus(RemoteRefUpdate.Status.NON_EXISTING);
                    continue;
                }
                rru.setStatus(RemoteRefUpdate.Status.UP_TO_DATE);
                continue;
            }
            if (rru.isExpectingOldObjectId() && !rru.getExpectedOldObjectId().equals(advertisedOld)) {
                rru.setStatus(RemoteRefUpdate.Status.REJECTED_REMOTE_CHANGED);
                if (!atomic) continue;
                return this.rejectAll();
            }
            if (!rru.isExpectingOldObjectId()) {
                rru.setExpectedOldObjectId(advertisedOld);
            }
            if (advertisedOld.equals(ObjectId.zeroId()) || rru.isDelete()) {
                rru.setFastForward(true);
                result2.put(rru.getRemoteName(), rru);
                continue;
            }
            boolean fastForward = this.isFastForward(advertisedOld, rru.getNewObjectId());
            rru.setFastForward(fastForward);
            if (!fastForward && !rru.isForceUpdate()) {
                rru.setStatus(RemoteRefUpdate.Status.REJECTED_NONFASTFORWARD);
                if (!atomic) continue;
                return this.rejectAll();
            }
            result2.put(rru.getRemoteName(), rru);
        }
        return result2;
    }

    private boolean isFastForward(ObjectId oldOid, ObjectId newOid) throws TransportException {
        try {
            RevObject oldRev = this.walker.parseAny(oldOid);
            RevObject newRev = this.walker.parseAny(newOid);
            return oldRev instanceof RevCommit && newRev instanceof RevCommit && this.walker.isMergedInto((RevCommit)oldRev, (RevCommit)newRev);
        }
        catch (MissingObjectException x) {
            return false;
        }
        catch (Exception x) {
            throw new TransportException(this.transport.getURI(), MessageFormat.format(JGitText.get().readingObjectsFromLocalRepositoryFailed, x.getMessage()), x);
        }
    }

    private Map<String, RemoteRefUpdate> expandMatching() throws TransportException {
        LinkedHashMap<String, RemoteRefUpdate> result2 = new LinkedHashMap<String, RemoteRefUpdate>();
        boolean hadMatch = false;
        for (RemoteRefUpdate update : this.toPush.values()) {
            if (update.isMatching()) {
                if (hadMatch) {
                    throw new TransportException(MessageFormat.format(JGitText.get().duplicateRemoteRefUpdateIsIllegal, ":"));
                }
                this.expandMatching(result2, update);
                hadMatch = true;
                continue;
            }
            if (result2.put(update.getRemoteName(), update) == null) continue;
            throw new TransportException(MessageFormat.format(JGitText.get().duplicateRemoteRefUpdateIsIllegal, update.getRemoteName()));
        }
        return result2;
    }

    private void expandMatching(Map<String, RemoteRefUpdate> updates, RemoteRefUpdate match) throws TransportException {
        try {
            Map<String, Ref> advertisement = this.connection.getRefsMap();
            Collection<RefSpec> fetchSpecs = match.getFetchSpecs();
            boolean forceUpdate = match.isForceUpdate();
            for (Ref local : this.transport.local.getRefDatabase().getRefsByPrefix("refs/heads/")) {
                RemoteRefUpdate rru;
                ObjectId newOid;
                ObjectId oldOid;
                String name;
                Ref advertised;
                if (local.isSymbolic() || (advertised = advertisement.get(name = local.getName())) == null || advertised.isSymbolic() || (oldOid = advertised.getObjectId()) == null || ObjectId.zeroId().equals(oldOid) || (newOid = local.getObjectId()) == null || ObjectId.zeroId().equals(newOid) || updates.put((rru = new RemoteRefUpdate(this.transport.local, name, newOid, name, forceUpdate, Transport.findTrackingRefName(name, fetchSpecs), oldOid)).getRemoteName(), rru) == null) continue;
                throw new TransportException(MessageFormat.format(JGitText.get().duplicateRemoteRefUpdateIsIllegal, rru.getRemoteName()));
            }
        }
        catch (IOException x) {
            throw new TransportException(this.transport.getURI(), MessageFormat.format(JGitText.get().readingObjectsFromLocalRepositoryFailed, x.getMessage()), x);
        }
    }

    private Map<String, RemoteRefUpdate> rejectAll() {
        for (RemoteRefUpdate rru : this.toPush.values()) {
            if (rru.getStatus() != RemoteRefUpdate.Status.NOT_ATTEMPTED) continue;
            rru.setStatus(RemoteRefUpdate.Status.REJECTED_OTHER_REASON);
            rru.setMessage(JGitText.get().transactionAborted);
        }
        return Collections.emptyMap();
    }

    private void modifyUpdatesForDryRun() {
        for (RemoteRefUpdate rru : this.toPush.values()) {
            if (rru.getStatus() != RemoteRefUpdate.Status.NOT_ATTEMPTED) continue;
            rru.setStatus(RemoteRefUpdate.Status.OK);
        }
    }

    private void updateTrackingRefs() {
        for (RemoteRefUpdate rru : this.toPush.values()) {
            RemoteRefUpdate.Status status = rru.getStatus();
            if (!rru.hasTrackingRefUpdate() || status != RemoteRefUpdate.Status.UP_TO_DATE && status != RemoteRefUpdate.Status.OK) continue;
            try {
                rru.updateTrackingRef(this.walker);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public List<String> getPushOptions() {
        return this.pushOptions;
    }
}

