/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import java.util.Arrays;
import org.eclipse.jgit.lib.GpgConfig;
import org.eclipse.jgit.lib.GpgSignatureVerifier;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.util.RawParseUtils;

public abstract class AbstractGpgSignatureVerifier
implements GpgSignatureVerifier {
    @Override
    public GpgSignatureVerifier.SignatureVerification verifySignature(RevObject object, GpgConfig config) throws IOException {
        if (object instanceof RevCommit) {
            RevCommit commit = (RevCommit)object;
            byte[] signatureData = commit.getRawGpgSignature();
            if (signatureData == null) {
                return null;
            }
            byte[] raw = commit.getRawBuffer();
            byte[] header = new byte[]{103, 112, 103, 115, 105, 103};
            int start = RawParseUtils.headerStart(header, raw, 0);
            if (start < 0) {
                return null;
            }
            int end = RawParseUtils.nextLfSkippingSplitLines(raw, start);
            start -= header.length + 1;
            if (end < raw.length) {
                ++end;
            }
            byte[] data2 = new byte[raw.length - (end - start)];
            System.arraycopy(raw, 0, data2, 0, start);
            System.arraycopy(raw, end, data2, start, raw.length - end);
            return this.verify(config, data2, signatureData);
        }
        if (object instanceof RevTag) {
            RevTag tag = (RevTag)object;
            byte[] signatureData = tag.getRawGpgSignature();
            if (signatureData == null) {
                return null;
            }
            byte[] raw = tag.getRawBuffer();
            byte[] data3 = Arrays.copyOfRange(raw, 0, raw.length - signatureData.length);
            return this.verify(config, data3, signatureData);
        }
        return null;
    }
}

