/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd.proxy;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.future.CancelOption;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.internal.transport.sshd.GssApiMechanisms;
import org.eclipse.jgit.internal.transport.sshd.SshdText;
import org.eclipse.jgit.internal.transport.sshd.auth.AuthenticationHandler;
import org.eclipse.jgit.internal.transport.sshd.auth.BasicAuthentication;
import org.eclipse.jgit.internal.transport.sshd.auth.GssApiAuthentication;
import org.eclipse.jgit.internal.transport.sshd.proxy.AbstractClientProxyConnector;
import org.eclipse.jgit.internal.transport.sshd.proxy.AuthenticationChallenge;
import org.eclipse.jgit.internal.transport.sshd.proxy.HttpParser;
import org.eclipse.jgit.internal.transport.sshd.proxy.StatusLine;
import org.eclipse.jgit.util.Base64;
import org.ietf.jgss.GSSContext;

public class HttpClientConnector
extends AbstractClientProxyConnector {
    private static final String HTTP_HEADER_PROXY_AUTHENTICATION = "Proxy-Authentication:";
    private static final String HTTP_HEADER_PROXY_AUTHORIZATION = "Proxy-Authorization:";
    private HttpAuthenticationHandler basic = new HttpBasicAuthentication();
    private HttpAuthenticationHandler negotiate = new NegotiateAuthentication();
    private List<HttpAuthenticationHandler> availableAuthentications = new ArrayList<HttpAuthenticationHandler>(2);
    private Iterator<HttpAuthenticationHandler> clientAuthentications;
    private HttpAuthenticationHandler authenticator;
    private boolean ongoing;

    public HttpClientConnector(@NonNull InetSocketAddress proxyAddress, @NonNull InetSocketAddress remoteAddress) {
        this(proxyAddress, remoteAddress, null, null);
    }

    public HttpClientConnector(@NonNull InetSocketAddress proxyAddress, @NonNull InetSocketAddress remoteAddress, String proxyUser, char[] proxyPassword) {
        super(proxyAddress, remoteAddress, proxyUser, proxyPassword);
        this.availableAuthentications.add(this.negotiate);
        this.availableAuthentications.add(this.basic);
        this.clientAuthentications = this.availableAuthentications.iterator();
    }

    private void close() {
        HttpAuthenticationHandler current = this.authenticator;
        this.authenticator = null;
        if (current != null) {
            current.close();
        }
    }

    @Override
    public void sendClientProxyMetadata(ClientSession sshSession) throws Exception {
        this.init(sshSession);
        IoSession session = sshSession.getIoSession();
        session.addCloseFutureListener(f -> this.close());
        StringBuilder msg = this.connect();
        if (this.proxyUser != null && !this.proxyUser.isEmpty() || this.proxyPassword != null && this.proxyPassword.length > 0) {
            this.authenticator = this.basic;
            this.basic.setParams(null);
            this.basic.start();
            msg = this.authenticate(msg, (String)this.basic.getToken());
            this.clearPassword();
            this.proxyUser = null;
        }
        this.ongoing = true;
        try {
            this.send(msg, session);
        }
        catch (Exception e) {
            this.ongoing = false;
            throw e;
        }
    }

    private void send(StringBuilder msg, IoSession session) throws Exception {
        byte[] data2 = this.eol(msg).toString().getBytes(StandardCharsets.US_ASCII);
        ByteArrayBuffer buffer = new ByteArrayBuffer(data2.length, false);
        buffer.putRawBytes(data2);
        session.writeBuffer(buffer).verify(this.getTimeout(), new CancelOption[0]);
    }

    private StringBuilder connect() {
        StringBuilder msg = new StringBuilder();
        return msg.append(MessageFormat.format("CONNECT {0}:{1} HTTP/1.1\r\nProxy-Connection: keep-alive\r\nConnection: keep-alive\r\nHost: {0}:{1}\r\n", this.remoteAddress.getHostString(), Integer.toString(this.remoteAddress.getPort())));
    }

    private StringBuilder authenticate(StringBuilder msg, String token) {
        msg.append(HTTP_HEADER_PROXY_AUTHORIZATION).append(' ').append(token);
        return this.eol(msg);
    }

    private StringBuilder eol(StringBuilder msg) {
        return msg.append('\r').append('\n');
    }

    @Override
    public void messageReceived(IoSession session, Readable buffer) throws Exception {
        try {
            int length = buffer.available();
            byte[] data2 = new byte[length];
            buffer.getRawBytes(data2, 0, length);
            String[] reply = new String(data2, StandardCharsets.US_ASCII).split("\r\n");
            this.handleMessage(session, Arrays.asList(reply));
        }
        catch (Exception e) {
            if (this.authenticator != null) {
                this.authenticator.close();
                this.authenticator = null;
            }
            this.ongoing = false;
            try {
                this.setDone(false);
            }
            catch (Exception inner) {
                e.addSuppressed(inner);
            }
            throw e;
        }
    }

    private void handleMessage(IoSession session, List<String> reply) throws Exception {
        if (reply.isEmpty() || reply.get(0).isEmpty()) {
            throw new IOException(MessageFormat.format(SshdText.get().proxyHttpUnexpectedReply, this.proxyAddress, "<empty>"));
        }
        try {
            StatusLine status = HttpParser.parseStatusLine(reply.get(0));
            if (!this.ongoing) {
                throw new IOException(MessageFormat.format(SshdText.get().proxyHttpUnexpectedReply, this.proxyAddress, Integer.toString(status.getResultCode()), status.getReason()));
            }
            switch (status.getResultCode()) {
                case 200: {
                    if (this.authenticator != null) {
                        this.authenticator.close();
                    }
                    this.authenticator = null;
                    this.ongoing = false;
                    this.setDone(true);
                    break;
                }
                case 407: {
                    List<AuthenticationChallenge> challenges = HttpParser.getAuthenticationHeaders(reply, HTTP_HEADER_PROXY_AUTHENTICATION);
                    this.authenticator = this.selectProtocol(challenges, this.authenticator);
                    if (this.authenticator == null) {
                        throw new IOException(MessageFormat.format(SshdText.get().proxyCannotAuthenticate, this.proxyAddress));
                    }
                    String token = (String)this.authenticator.getToken();
                    if (token == null) {
                        throw new IOException(MessageFormat.format(SshdText.get().proxyCannotAuthenticate, this.proxyAddress));
                    }
                    this.send(this.authenticate(this.connect(), token), session);
                    break;
                }
                default: {
                    throw new IOException(MessageFormat.format(SshdText.get().proxyHttpFailure, this.proxyAddress, Integer.toString(status.getResultCode()), status.getReason()));
                }
            }
        }
        catch (HttpParser.ParseException e) {
            throw new IOException(MessageFormat.format(SshdText.get().proxyHttpUnexpectedReply, this.proxyAddress, reply.get(0)), e);
        }
    }

    private HttpAuthenticationHandler selectProtocol(List<AuthenticationChallenge> challenges, HttpAuthenticationHandler current) throws Exception {
        AuthenticationChallenge challenge;
        if (current != null && !current.isDone() && (challenge = this.getByName(challenges, current.getName())) != null) {
            current.setParams(challenge);
            current.process();
            return current;
        }
        if (current != null) {
            current.close();
        }
        while (this.clientAuthentications.hasNext()) {
            AuthenticationChallenge challenge2;
            HttpAuthenticationHandler next = this.clientAuthentications.next();
            if (next.isDone() || (challenge2 = this.getByName(challenges, next.getName())) == null) continue;
            next.setParams(challenge2);
            next.start();
            return next;
        }
        return null;
    }

    private AuthenticationChallenge getByName(List<AuthenticationChallenge> challenges, String name) {
        return challenges.stream().filter(c -> c.getMechanism().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    private static interface HttpAuthenticationHandler
    extends AuthenticationHandler<AuthenticationChallenge, String> {
        public String getName();
    }

    private class HttpBasicAuthentication
    extends BasicAuthentication<AuthenticationChallenge, String>
    implements HttpAuthenticationHandler {
        private boolean asked;

        public HttpBasicAuthentication() {
            super(HttpClientConnector.this.proxyAddress, HttpClientConnector.this.proxyUser, HttpClientConnector.this.proxyPassword);
        }

        @Override
        public String getName() {
            return "Basic";
        }

        @Override
        protected void askCredentials() {
            if (this.asked) {
                throw new IllegalStateException("Basic auth: already asked user for password");
            }
            this.asked = true;
            super.askCredentials();
            this.done = true;
        }

        @Override
        public String getToken() throws Exception {
            if (this.user.indexOf(58) >= 0) {
                throw new IOException(MessageFormat.format(SshdText.get().proxyHttpInvalidUserName, this.proxy, this.user));
            }
            byte[] rawUser = this.user.getBytes(StandardCharsets.UTF_8);
            byte[] toEncode = new byte[rawUser.length + 1 + this.password.length];
            System.arraycopy(rawUser, 0, toEncode, 0, rawUser.length);
            toEncode[rawUser.length] = 58;
            System.arraycopy(this.password, 0, toEncode, rawUser.length + 1, this.password.length);
            Arrays.fill(this.password, (byte)0);
            String result2 = Base64.encodeBytes(toEncode);
            Arrays.fill(toEncode, (byte)0);
            return this.getName() + " " + result2;
        }
    }

    private class NegotiateAuthentication
    extends GssApiAuthentication<AuthenticationChallenge, String>
    implements HttpAuthenticationHandler {
        public NegotiateAuthentication() {
            super(HttpClientConnector.this.proxyAddress);
        }

        @Override
        public String getName() {
            return "Negotiate";
        }

        @Override
        public String getToken() throws Exception {
            return this.getName() + " " + Base64.encodeBytes(this.token);
        }

        @Override
        protected GSSContext createContext() throws Exception {
            return GssApiMechanisms.createContext(GssApiMechanisms.SPNEGO, GssApiMechanisms.getCanonicalName(HttpClientConnector.this.proxyAddress));
        }

        @Override
        protected byte[] extractToken(AuthenticationChallenge input) throws Exception {
            String received = input.getToken();
            if (received == null) {
                return new byte[0];
            }
            return Base64.decode(received);
        }
    }
}

