/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.nio.charset.Charset;
import java.nio.file.FileStore;
import java.nio.file.FileSystemException;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.ClientSessionHolder;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.ChannelListener;
import org.apache.sshd.common.file.util.BaseFileSystem;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionHolder;
import org.apache.sshd.common.session.SessionListener;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.sftp.SftpModuleProperties;
import org.apache.sshd.sftp.client.RawSftpClient;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.SftpClientFactory;
import org.apache.sshd.sftp.client.SftpErrorDataHandler;
import org.apache.sshd.sftp.client.SftpVersionSelector;
import org.apache.sshd.sftp.client.fs.SftpFileStore;
import org.apache.sshd.sftp.client.fs.SftpFileSystemProvider;
import org.apache.sshd.sftp.client.fs.SftpPath;
import org.apache.sshd.sftp.client.impl.AbstractSftpClient;
import org.apache.sshd.sftp.client.impl.SftpPathImpl;
import org.apache.sshd.sftp.common.SftpConstants;

public class SftpFileSystem
extends BaseFileSystem<SftpPath>
implements SessionHolder<ClientSession>,
ClientSessionHolder {
    public static final NavigableSet<String> UNIVERSAL_SUPPORTED_VIEWS = Collections.unmodifiableNavigableSet(GenericUtils.asSortedSet(String.CASE_INSENSITIVE_ORDER, new String[]{"basic", "posix", "owner"}));
    public static final AttributeRepository.AttributeKey<Boolean> OWNED_SESSION = new AttributeRepository.AttributeKey();
    private final String id;
    private final SftpClientFactory factory;
    private final SftpVersionSelector selector;
    private final SftpErrorDataHandler errorDataHandler;
    private SftpClientPool pool;
    private int version;
    private Set<String> supportedViews;
    private SftpPath defaultDir;
    private int readBufferSize;
    private int writeBufferSize;
    private final List<FileStore> stores;
    private final AtomicBoolean open = new AtomicBoolean();
    private AtomicReference<ClientSession> clientSession = new AtomicReference();

    public SftpFileSystem(SftpFileSystemProvider provider, String id, ClientSession session, SftpClientFactory factory, SftpVersionSelector selector, SftpErrorDataHandler errorDataHandler) throws IOException {
        this(provider, id, factory, selector, errorDataHandler);
        this.clientSession.set(Objects.requireNonNull(session, "No client session"));
        if (!Boolean.TRUE.equals(session.getAttribute(OWNED_SESSION))) {
            session.addSessionListener(new SessionListener(){

                @Override
                public void sessionClosed(Session session) {
                    if (SftpFileSystem.this.clientSession.get() == session) {
                        try {
                            SftpFileSystem.this.close();
                        }
                        catch (IOException e) {
                            SftpFileSystem.this.log.warn("sessionClosed({}) [{}] could not close file system properly: {}", session, SftpFileSystem.this, e.toString(), e);
                        }
                    }
                }
            });
        }
        this.init();
    }

    protected SftpFileSystem(SftpFileSystemProvider provider, String id, SftpClientFactory factory, SftpVersionSelector selector, SftpErrorDataHandler errorDataHandler) {
        super(provider);
        this.id = id;
        this.factory = factory != null ? factory : SftpClientFactory.instance();
        this.selector = selector;
        this.errorDataHandler = errorDataHandler;
        this.stores = Collections.singletonList(new SftpFileStore(id, this));
    }

    protected void init() throws IOException {
        this.open.set(true);
        try (SftpClient client = this.getClient();){
            ClientSession session = client.getClientSession();
            this.pool = new SftpClientPool(SftpModuleProperties.POOL_SIZE.getRequired(session), SftpModuleProperties.POOL_LIFE_TIME.getRequired(session), SftpModuleProperties.POOL_CORE_SIZE.getRequired(session));
            this.version = client.getVersion();
            this.defaultDir = (SftpPath)this.getPath(client.canonicalPath("."), new String[0]);
        }
        catch (IOException | RuntimeException e) {
            this.open.set(false);
            if (this.pool != null) {
                this.pool.close();
            }
            throw e;
        }
        if (this.version >= 4) {
            TreeSet<String> views = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            views.addAll(UNIVERSAL_SUPPORTED_VIEWS);
            views.add("acl");
            this.supportedViews = Collections.unmodifiableSet(views);
        } else {
            this.supportedViews = UNIVERSAL_SUPPORTED_VIEWS;
        }
    }

    public final SftpVersionSelector getSftpVersionSelector() {
        return this.selector;
    }

    public SftpErrorDataHandler getSftpErrorDataHandler() {
        return this.errorDataHandler;
    }

    public final String getId() {
        return this.id;
    }

    public final int getVersion() {
        return this.version;
    }

    @Override
    public SftpFileSystemProvider provider() {
        return (SftpFileSystemProvider)super.provider();
    }

    public List<FileStore> getFileStores() {
        return this.stores;
    }

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public void setReadBufferSize(int size) {
        if (size < 256) {
            throw new IllegalArgumentException("Insufficient read buffer size: " + size + ", min.=" + 256);
        }
        this.readBufferSize = size;
    }

    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public void setWriteBufferSize(int size) {
        if (size < 256) {
            throw new IllegalArgumentException("Insufficient write buffer size: " + size + ", min.=" + 256);
        }
        this.writeBufferSize = size;
    }

    @Override
    protected SftpPath create(String root, List<String> names) {
        return new SftpPathImpl(this, root, names);
    }

    @Override
    public ClientSession getClientSession() {
        return this.clientSession.get();
    }

    @Override
    public ClientSession getSession() {
        return this.getClientSession();
    }

    protected void setClientSession(ClientSession newSession) {
        this.clientSession.set(newSession);
    }

    protected ClientSession sessionForSftpClient() throws IOException {
        return this.getClientSession();
    }

    public SftpClient getClient() throws IOException {
        Wrapper wrapper = null;
        do {
            SftpClient client;
            if (!this.isOpen()) {
                throw new IOException("SftpFileSystem is closed" + this);
            }
            SftpClient sftpClient = client = this.pool != null ? this.pool.poll() : null;
            if (client == null) {
                ClientSession session = this.sessionForSftpClient();
                client = this.factory.createSftpClient(session, this.getSftpVersionSelector(), this.getSftpErrorDataHandler());
            }
            if (client.isClosing()) continue;
            wrapper = new Wrapper(client, this.getSftpErrorDataHandler(), this.getReadBufferSize(), this.getWriteBufferSize());
        } while (wrapper == null);
        return wrapper;
    }

    @Override
    public void close() throws IOException {
        if (this.open.getAndSet(false)) {
            if (this.pool != null) {
                this.pool.close();
            }
            SftpFileSystemProvider provider = this.provider();
            String fsId = this.getId();
            SftpFileSystem fs = provider.removeFileSystem(fsId);
            ClientSession session = this.getClientSession();
            if (Boolean.TRUE.equals(session.getAttribute(OWNED_SESSION))) {
                session.close(true);
            }
            if (fs != null && fs != this) {
                throw new FileSystemException(fsId, fsId, "Mismatched FS instance for id=" + fsId);
            }
        }
    }

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return this.supportedViews;
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        return DefaultUserPrincipalLookupService.INSTANCE;
    }

    @Override
    public SftpPath getDefaultDir() {
        return this.defaultDir;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getClientSession() + "]";
    }

    protected class SftpClientPool {
        private final ScheduledExecutorService timeouts;
        private final BlockingQueue<SftpClientHandle> pool;
        private final long idleLifeTime;
        private final int coreSize;

        public SftpClientPool(int maxSize, Duration idleLifeTime, int coreSize) {
            long timeout;
            ValidateUtils.checkState(idleLifeTime == null || !idleLifeTime.isNegative(), "idleLifeTime must not be negative");
            long l = timeout = idleLifeTime == null ? 0L : idleLifeTime.toMillis();
            if (timeout == 0L && idleLifeTime != null && !idleLifeTime.isZero()) {
                timeout = 1L;
            }
            if (timeout > 0L) {
                ValidateUtils.checkState(coreSize >= 0, "coreSize must not be neagtive");
                if (coreSize > maxSize) {
                    SftpFileSystem.this.log.warn("SftpClientPool {}: pool core size > pool maximum size, channels will not expire", (Object)SftpFileSystem.this);
                }
                if (coreSize >= maxSize) {
                    timeout = 0L;
                }
            }
            this.pool = new LinkedBlockingQueue<SftpClientHandle>(maxSize);
            this.coreSize = coreSize;
            this.idleLifeTime = timeout;
            this.timeouts = timeout > 0L ? Executors.newScheduledThreadPool(1) : null;
        }

        public void close() {
            if (this.timeouts != null && !this.timeouts.isShutdown()) {
                this.timeouts.shutdownNow();
            }
            ArrayList handles = new ArrayList(this.pool.size());
            this.pool.drainTo(handles);
            handles.forEach(this::closeSilently);
        }

        public SftpClient poll() {
            SftpClient client = null;
            while (client == null) {
                SftpClientHandle handle;
                SftpClientHandle sftpClientHandle = handle = SftpFileSystem.this.open.get() ? (SftpClientHandle)this.pool.poll() : null;
                if (handle == null) {
                    return null;
                }
                client = handle.getClient();
                if (client.isOpen()) continue;
                client = null;
            }
            return client;
        }

        public boolean offer(SftpClient client) {
            boolean wasAdded;
            SftpClientHandle handle = new SftpClientHandle(this.pool, client);
            boolean bl = wasAdded = SftpFileSystem.this.open.get() && this.pool.offer(handle);
            if (wasAdded && this.timeouts != null) {
                try {
                    handle.setExpiration(this.timeouts.schedule(() -> {
                        if (this.pool.size() > this.coreSize && this.pool.remove(handle)) {
                            this.closeSilently(handle);
                        }
                    }, this.idleLifeTime, TimeUnit.MILLISECONDS));
                }
                catch (RejectedExecutionException e) {
                    SftpFileSystem.this.log.warn("SftpClientPool {} [{}]: cannot schedule idle closure: {}", SftpFileSystem.this, client, e.toString());
                }
            } else if (!wasAdded) {
                handle.destroy();
            }
            return wasAdded;
        }

        private void closeSilently(SftpClientHandle handle) {
            SftpClient client = handle.getClient();
            try {
                client.close();
            }
            catch (IOException e) {
                SftpFileSystem.this.log.warn("SftpClientPool {} [{}]: cannot close SftpClient properly: {}", SftpFileSystem.this, client, e.toString());
            }
        }
    }

    private final class Wrapper
    extends AbstractSftpClient {
        private final SftpClient delegate;
        private final int readSize;
        private final int writeSize;
        private final AtomicBoolean open;

        private Wrapper(SftpClient delegate, SftpErrorDataHandler errorHandler, int readSize, int writeSize) {
            super(errorHandler);
            this.open = new AtomicBoolean();
            this.delegate = delegate;
            this.readSize = readSize;
            this.writeSize = writeSize;
            this.open.set(delegate.isOpen());
        }

        @Override
        public int getVersion() {
            return this.delegate.getVersion();
        }

        @Override
        public ClientSession getClientSession() {
            return this.delegate.getClientSession();
        }

        @Override
        public ClientChannel getClientChannel() {
            return this.delegate.getClientChannel();
        }

        @Override
        public NavigableMap<String, byte[]> getServerExtensions() {
            return this.delegate.getServerExtensions();
        }

        @Override
        public Charset getNameDecodingCharset() {
            return this.delegate.getNameDecodingCharset();
        }

        @Override
        public void setNameDecodingCharset(Charset cs) {
            this.delegate.setNameDecodingCharset(cs);
        }

        @Override
        public boolean isClosing() {
            if (!this.open.get()) {
                return true;
            }
            if (!this.delegate.isOpen()) {
                this.open.set(false);
                return true;
            }
            return false;
        }

        @Override
        public boolean isOpen() {
            return this.open.get() && this.delegate.isOpen();
        }

        @Override
        public void close() throws IOException {
            if (this.open.getAndSet(false) && this.delegate.isOpen() && !SftpFileSystem.this.pool.offer(this.delegate)) {
                this.delegate.close();
            }
        }

        @Override
        public SftpClient.CloseableHandle open(String path, Collection<SftpClient.OpenMode> options2) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("open(" + path + ")[" + options2 + "] client is closed");
            }
            return this.delegate.open(path, options2);
        }

        @Override
        public void close(SftpClient.Handle handle) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("close(" + handle + ") client is closed");
            }
            this.delegate.close(handle);
        }

        @Override
        public void remove(String path) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("remove(" + path + ") client is closed");
            }
            this.delegate.remove(path);
        }

        @Override
        public void rename(String oldPath, String newPath, Collection<SftpClient.CopyMode> options2) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("rename(" + oldPath + " => " + newPath + ")[" + options2 + "] client is closed");
            }
            this.delegate.rename(oldPath, newPath, options2);
        }

        @Override
        public int read(SftpClient.Handle handle, long fileOffset, byte[] dst, int dstOffset, int len) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("read(" + handle + "/" + fileOffset + ")[" + dstOffset + "/" + len + "] client is closed");
            }
            return this.delegate.read(handle, fileOffset, dst, dstOffset, len);
        }

        @Override
        public void write(SftpClient.Handle handle, long fileOffset, byte[] src, int srcOffset, int len) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("write(" + handle + "/" + fileOffset + ")[" + srcOffset + "/" + len + "] client is closed");
            }
            this.delegate.write(handle, fileOffset, src, srcOffset, len);
        }

        @Override
        public void mkdir(String path) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("mkdir(" + path + ") client is closed");
            }
            this.delegate.mkdir(path);
        }

        @Override
        public void rmdir(String path) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("rmdir(" + path + ") client is closed");
            }
            this.delegate.rmdir(path);
        }

        @Override
        public SftpClient.CloseableHandle openDir(String path) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("openDir(" + path + ") client is closed");
            }
            return this.delegate.openDir(path);
        }

        @Override
        public List<SftpClient.DirEntry> readDir(SftpClient.Handle handle) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("readDir(" + handle + ") client is closed");
            }
            return this.delegate.readDir(handle);
        }

        @Override
        public Iterable<SftpClient.DirEntry> listDir(SftpClient.Handle handle) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("readDir(" + handle + ") client is closed");
            }
            return this.delegate.listDir(handle);
        }

        @Override
        public String canonicalPath(String path) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("canonicalPath(" + path + ") client is closed");
            }
            return this.delegate.canonicalPath(path);
        }

        @Override
        public SftpClient.Attributes stat(String path) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("stat(" + path + ") client is closed");
            }
            return this.delegate.stat(path);
        }

        @Override
        public SftpClient.Attributes lstat(String path) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("lstat(" + path + ") client is closed");
            }
            return this.delegate.lstat(path);
        }

        @Override
        public SftpClient.Attributes stat(SftpClient.Handle handle) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("stat(" + handle + ") client is closed");
            }
            return this.delegate.stat(handle);
        }

        @Override
        public void setStat(String path, SftpClient.Attributes attributes) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("setStat(" + path + ")[" + attributes + "] client is closed");
            }
            this.delegate.setStat(path, attributes);
        }

        @Override
        public void setStat(SftpClient.Handle handle, SftpClient.Attributes attributes) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("setStat(" + handle + ")[" + attributes + "] client is closed");
            }
            this.delegate.setStat(handle, attributes);
        }

        @Override
        public String readLink(String path) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("readLink(" + path + ") client is closed");
            }
            return this.delegate.readLink(path);
        }

        @Override
        public void symLink(String linkPath, String targetPath) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("symLink(" + linkPath + " => " + targetPath + ") client is closed");
            }
            this.delegate.symLink(linkPath, targetPath);
        }

        @Override
        public List<SftpClient.DirEntry> readDir(SftpClient.Handle handle, AtomicReference<Boolean> eolIndicator) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("readDir(" + handle + ") client is closed");
            }
            return this.delegate.readDir(handle, eolIndicator);
        }

        @Override
        public InputStream read(String path) throws IOException {
            return this.read(path, this.readSize);
        }

        @Override
        public InputStream read(String path, SftpClient.OpenMode ... mode) throws IOException {
            return this.read(path, this.readSize, mode);
        }

        @Override
        public InputStream read(String path, Collection<SftpClient.OpenMode> mode) throws IOException {
            return this.read(path, this.readSize, mode);
        }

        @Override
        public OutputStream write(String path) throws IOException {
            return this.write(path, this.writeSize);
        }

        @Override
        public OutputStream write(String path, SftpClient.OpenMode ... mode) throws IOException {
            return this.write(path, this.writeSize, mode);
        }

        @Override
        public OutputStream write(String path, Collection<SftpClient.OpenMode> mode) throws IOException {
            return this.write(path, this.writeSize, mode);
        }

        @Override
        public void link(String linkPath, String targetPath, boolean symbolic) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("link(" + linkPath + " => " + targetPath + "] symbolic=" + symbolic + ": client is closed");
            }
            this.delegate.link(linkPath, targetPath, symbolic);
        }

        @Override
        public void lock(SftpClient.Handle handle, long offset, long length, int mask) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("lock(" + handle + ")[offset=" + offset + ", length=" + length + ", mask=0x" + Integer.toHexString(mask) + "] client is closed");
            }
            this.delegate.lock(handle, offset, length, mask);
        }

        @Override
        public void unlock(SftpClient.Handle handle, long offset, long length) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("unlock" + handle + ")[offset=" + offset + ", length=" + length + "] client is closed");
            }
            this.delegate.unlock(handle, offset, length);
        }

        @Override
        public int send(int cmd, Buffer buffer) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("send(cmd=" + SftpConstants.getCommandMessageName(cmd) + ") client is closed");
            }
            if (this.delegate instanceof RawSftpClient) {
                return ((RawSftpClient)((Object)this.delegate)).send(cmd, buffer);
            }
            throw new StreamCorruptedException("send(cmd=" + SftpConstants.getCommandMessageName(cmd) + ") delegate is not a " + RawSftpClient.class.getSimpleName());
        }

        @Override
        public Buffer receive(int id) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("receive(id=" + id + ") client is closed");
            }
            if (this.delegate instanceof RawSftpClient) {
                return ((RawSftpClient)((Object)this.delegate)).receive(id);
            }
            throw new StreamCorruptedException("receive(id=" + id + ") delegate is not a " + RawSftpClient.class.getSimpleName());
        }

        @Override
        public Buffer receive(int id, long timeout) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("receive(id=" + id + ", timeout=" + timeout + ") client is closed");
            }
            if (this.delegate instanceof RawSftpClient) {
                return ((RawSftpClient)((Object)this.delegate)).receive(id, timeout);
            }
            throw new StreamCorruptedException("receive(id=" + id + ", timeout=" + timeout + ") delegate is not a " + RawSftpClient.class.getSimpleName());
        }

        @Override
        public Buffer receive(int id, Duration timeout) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("receive(id=" + id + ", timeout=" + timeout + ") client is closed");
            }
            if (this.delegate instanceof RawSftpClient) {
                return ((RawSftpClient)((Object)this.delegate)).receive(id, timeout);
            }
            throw new StreamCorruptedException("receive(id=" + id + ", timeout=" + timeout + ") delegate is not a " + RawSftpClient.class.getSimpleName());
        }
    }

    public static class DefaultUserPrincipalLookupService
    extends UserPrincipalLookupService {
        public static final DefaultUserPrincipalLookupService INSTANCE = new DefaultUserPrincipalLookupService();

        @Override
        public UserPrincipal lookupPrincipalByName(String name) throws IOException {
            return new DefaultUserPrincipal(name);
        }

        @Override
        public GroupPrincipal lookupPrincipalByGroupName(String group) throws IOException {
            return new DefaultGroupPrincipal(group);
        }
    }

    protected static class SftpClientHandle
    implements ChannelListener {
        private final SftpClient client;
        private final BlockingQueue<? extends SftpClientHandle> pool;
        private Future<?> expiration;

        public SftpClientHandle(BlockingQueue<? extends SftpClientHandle> pool, SftpClient client) {
            this.pool = Objects.requireNonNull(pool);
            this.client = Objects.requireNonNull(client);
            Channel channel = client.getChannel();
            if (channel != null) {
                channel.addChannelListener(this);
            }
        }

        public void destroy() {
            Channel channel;
            if (this.expiration != null) {
                this.expiration.cancel(true);
            }
            if ((channel = this.client.getChannel()) != null) {
                channel.removeChannelListener(this);
            }
        }

        public SftpClient getClient() {
            this.destroy();
            return this.client;
        }

        public void setExpiration(Future<?> future) {
            this.expiration = future;
        }

        @Override
        public void channelClosed(Channel channel, Throwable reason) {
            if (this.pool.remove(this)) {
                channel.removeChannelListener(this);
            }
        }
    }

    public static class DefaultGroupPrincipal
    extends DefaultUserPrincipal
    implements GroupPrincipal {
        public DefaultGroupPrincipal(String name) {
            super(name);
        }
    }

    public static class DefaultUserPrincipal
    implements UserPrincipal {
        private final String name;

        public DefaultUserPrincipal(String name) {
            this.name = Objects.requireNonNull(name, "name is null");
        }

        @Override
        public final String getName() {
            return this.name;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultUserPrincipal that = (DefaultUserPrincipal)o;
            return Objects.equals(this.getName(), that.getName());
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.getName());
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }
}

