/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.io.resource.IoResource;
import org.apache.sshd.common.util.io.resource.PathResource;
import org.apache.sshd.common.util.io.resource.URLResource;

@FunctionalInterface
public interface KeyPairResourceLoader {
    public static final int MAX_CIPHER_NAME_LENGTH = 256;
    public static final int MAX_KEY_TYPE_NAME_LENGTH = 256;
    public static final int MAX_KEY_COMMENT_LENGTH = 1024;
    public static final int MAX_PUBLIC_KEY_DATA_SIZE = 65534;
    public static final int MAX_PRIVATE_KEY_DATA_SIZE = 262136;
    public static final KeyPairResourceLoader EMPTY = (session, resourceKey, passwordProvider, lines) -> Collections.emptyList();

    default public Collection<KeyPair> loadKeyPairs(SessionContext session, Path path, FilePasswordProvider passwordProvider, OpenOption ... options2) throws IOException, GeneralSecurityException {
        return this.loadKeyPairs(session, path, passwordProvider, StandardCharsets.UTF_8, options2);
    }

    default public Collection<KeyPair> loadKeyPairs(SessionContext session, Path path, FilePasswordProvider passwordProvider, Charset cs, OpenOption ... options2) throws IOException, GeneralSecurityException {
        return this.loadKeyPairs(session, new PathResource(path, options2), passwordProvider, cs);
    }

    default public Collection<KeyPair> loadKeyPairs(SessionContext session, URL url, FilePasswordProvider passwordProvider) throws IOException, GeneralSecurityException {
        return this.loadKeyPairs(session, url, passwordProvider, StandardCharsets.UTF_8);
    }

    default public Collection<KeyPair> loadKeyPairs(SessionContext session, URL url, FilePasswordProvider passwordProvider, Charset cs) throws IOException, GeneralSecurityException {
        return this.loadKeyPairs(session, new URLResource(url), passwordProvider, cs);
    }

    default public Collection<KeyPair> loadKeyPairs(SessionContext session, IoResource<?> resource, FilePasswordProvider passwordProvider) throws IOException, GeneralSecurityException {
        return this.loadKeyPairs(session, resource, passwordProvider, StandardCharsets.UTF_8);
    }

    default public Collection<KeyPair> loadKeyPairs(SessionContext session, IoResource<?> resource, FilePasswordProvider passwordProvider, Charset cs) throws IOException, GeneralSecurityException {
        try (InputStream stream = Objects.requireNonNull(resource, "No resource data").openInputStream();){
            Collection<KeyPair> collection = this.loadKeyPairs(session, resource, passwordProvider, stream, cs);
            return collection;
        }
    }

    default public Collection<KeyPair> loadKeyPairs(SessionContext session, NamedResource resourceKey, FilePasswordProvider passwordProvider, String data2) throws IOException, GeneralSecurityException {
        try (StringReader reader = new StringReader(data2 == null ? "" : data2);){
            Collection<KeyPair> collection = this.loadKeyPairs(session, resourceKey, passwordProvider, reader);
            return collection;
        }
    }

    default public Collection<KeyPair> loadKeyPairs(SessionContext session, NamedResource resourceKey, FilePasswordProvider passwordProvider, InputStream stream) throws IOException, GeneralSecurityException {
        return this.loadKeyPairs(session, resourceKey, passwordProvider, stream, StandardCharsets.UTF_8);
    }

    default public Collection<KeyPair> loadKeyPairs(SessionContext session, NamedResource resourceKey, FilePasswordProvider passwordProvider, InputStream stream, Charset cs) throws IOException, GeneralSecurityException {
        try (InputStreamReader reader = new InputStreamReader(Objects.requireNonNull(stream, "No stream instance"), Objects.requireNonNull(cs, "No charset"));){
            Collection<KeyPair> collection = this.loadKeyPairs(session, resourceKey, passwordProvider, reader);
            return collection;
        }
    }

    default public Collection<KeyPair> loadKeyPairs(SessionContext session, NamedResource resourceKey, FilePasswordProvider passwordProvider, Reader r) throws IOException, GeneralSecurityException {
        try (BufferedReader br = new BufferedReader(Objects.requireNonNull(r, "No reader instance"), 8192);){
            Collection<KeyPair> collection = this.loadKeyPairs(session, resourceKey, passwordProvider, br);
            return collection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public Collection<KeyPair> loadKeyPairs(SessionContext session, NamedResource resourceKey, FilePasswordProvider passwordProvider, BufferedReader r) throws IOException, GeneralSecurityException {
        List<String> lines = IoUtils.readAllLines(r);
        try {
            Collection<KeyPair> collection = this.loadKeyPairs(session, resourceKey, passwordProvider, lines);
            return collection;
        }
        finally {
            lines.clear();
        }
    }

    public Collection<KeyPair> loadKeyPairs(SessionContext var1, NamedResource var2, FilePasswordProvider var3, List<String> var4) throws IOException, GeneralSecurityException;
}

