/*
 * Decompiled with CFR 0.152.
 */
package file;

import file.FileUtilsKt;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007\u001a\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0002\u001a\u0016\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007\u001a\u001c\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u0002\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0011"}, d2={"log", "Lmu/KLogger;", "getLog", "()Lmu/KLogger;", "clearFile", "", "it", "Ljava/nio/file/Path;", "clearFolder", "dir", "clearPathInternal", "copyFolder", "src", "dest", "copyPath", "source", "target", "WurstSetup"})
public final class FileUtilsKt {
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger(log.1.INSTANCE);

    @NotNull
    public static final KLogger getLog() {
        return log;
    }

    public static final void clearFolder(@NotNull Path dir) {
        Intrinsics.checkNotNullParameter(dir, "dir");
        log.debug("clearing: " + dir);
        Files.walk(dir, new FileVisitOption[0]).forEach(arg_0 -> FileUtilsKt.clearFolder$lambda$0(new Function1<Path, Unit>(dir){
            final /* synthetic */ Path $dir;
            {
                this.$dir = $dir;
                super(1);
            }

            public final void invoke(Path it) {
                Intrinsics.checkNotNull(it);
                FileUtilsKt.access$clearPathInternal(it, this.$dir);
            }
        }, arg_0));
    }

    public static final void clearFile(@NotNull Path it) {
        Intrinsics.checkNotNullParameter(it, "it");
        try {
            Files.delete(it);
        }
        catch (Exception _e) {
            String string = _e.getMessage();
            boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, "it is being used by another process", false, 2, null) : false;
            if (bl) {
                log.warn("It seems like wurst is still running. some files might not be removed.");
            }
            log.error("Exception: ", _e);
        }
    }

    public static final void copyFolder(@NotNull Path src, @NotNull Path dest) {
        Intrinsics.checkNotNullParameter(src, "src");
        Intrinsics.checkNotNullParameter(dest, "dest");
        try {
            Files.walk(src, new FileVisitOption[0]).forEach(arg_0 -> FileUtilsKt.copyFolder$lambda$1(new Function1<Path, Unit>(dest, src){
                final /* synthetic */ Path $dest;
                final /* synthetic */ Path $src;
                {
                    this.$dest = $dest;
                    this.$src = $src;
                    super(1);
                }

                public final void invoke(Path source) {
                    try {
                        Path target = this.$dest.resolve(this.$src.relativize(source));
                        FileUtilsKt.access$copyPath(source, target);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }, arg_0));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static final void copyPath(Path source, Path target) {
        if (Files.isDirectory(source, new LinkOption[0])) {
            if (!Files.exists(target, new LinkOption[0])) {
                Files.createDirectory(target, new FileAttribute[0]);
            }
        } else {
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Files.copy(source, target, copyOptionArray);
        }
    }

    private static final void clearPathInternal(Path it, Path dir) {
        if (!Intrinsics.areEqual(it, dir)) {
            if (Files.isDirectory(it, new LinkOption[0])) {
                FileUtilsKt.clearFolder(it);
            } else {
                FileUtilsKt.clearFile(it);
            }
        }
    }

    private static final void clearFolder$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void copyFolder$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$clearPathInternal(Path it, Path dir) {
        FileUtilsKt.clearPathInternal(it, dir);
    }

    public static final /* synthetic */ void access$copyPath(Path source, Path target) {
        FileUtilsKt.copyPath(source, target);
    }
}

