/*
 * Decompiled with CFR 0.152.
 */
package workers;

import file.Download;
import global.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.net.HttpURLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ui.MainWindow;
import workers.DownloadWithProgressWorker;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B.\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0017\u0010\b\u001a\u0013\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\u0010\rJ\u000f\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u0014\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u000bH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\u0013\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\b\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lworkers/DownloadWithProgressWorker;", "Ljavax/swing/SwingWorker;", "", "Ljava/lang/Void;", "filePath", "", "progressBar", "Ljavax/swing/JProgressBar;", "finish", "Lkotlin/Function1;", "Ljava/nio/file/Path;", "", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/String;Ljavax/swing/JProgressBar;Lkotlin/jvm/functions/Function1;)V", "filename", "getFinish", "()Lkotlin/jvm/functions/Function1;", "log", "Lmu/KLogger;", "doInBackground", "()Ljava/lang/Boolean;", "done", "WurstSetup"})
public final class DownloadWithProgressWorker
extends SwingWorker<Boolean, Void> {
    @NotNull
    private final String filePath;
    @NotNull
    private final JProgressBar progressBar;
    @NotNull
    private final Function1<Path, Unit> finish;
    @NotNull
    private final KLogger log;
    @NotNull
    private String filename;

    public DownloadWithProgressWorker(@NotNull String filePath, @NotNull JProgressBar progressBar, @NotNull Function1<? super Path, Unit> finish) {
        Intrinsics.checkNotNullParameter(filePath, "filePath");
        Intrinsics.checkNotNullParameter(progressBar, "progressBar");
        Intrinsics.checkNotNullParameter(finish, "finish");
        this.filePath = filePath;
        this.progressBar = progressBar;
        this.finish = finish;
        this.log = KotlinLogging.INSTANCE.logger(log.1.INSTANCE);
        this.filename = "";
    }

    @NotNull
    public final Function1<Path, Unit> getFinish() {
        return this.finish;
    }

    @Override
    @Nullable
    protected Boolean doInBackground() throws Exception {
        try {
            SwingUtilities.invokeLater(() -> DownloadWithProgressWorker.doInBackground$lambda$0(this));
            MainWindow.INSTANCE.getUi().disableButtons();
            HttpURLConnection httpConnection = Download.INSTANCE.getHttpURLConnection(this.filePath);
            int completeFileSize = httpConnection.getContentLength();
            int size = completeFileSize / 1024 / 1024;
            Log.INSTANCE.print("(" + (size == 0 ? "<1" : Integer.valueOf(size)) + "MB)");
            BufferedInputStream input = new BufferedInputStream(httpConnection.getInputStream());
            String string = this.filePath.substring(StringsKt.lastIndexOf$default((CharSequence)this.filePath, "/", 0, false, 6, null) + 1);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
            this.filename = string;
            if (Files.exists(Paths.get(this.filename, new String[0]), new LinkOption[0])) {
                this.filename = this.filename + ".2.jar";
            }
            FileOutputStream fos = new FileOutputStream(this.filename);
            BufferedOutputStream bout = new BufferedOutputStream(fos, 1024);
            byte[] data2 = new byte[1024];
            long downloadedFileSize = 0L;
            int x = input.read(data2, 0, 1024);
            do {
                int currentProgress = (int)((double)(downloadedFileSize += (long)x) / (double)completeFileSize * 100.0);
                SwingUtilities.invokeLater(() -> DownloadWithProgressWorker.doInBackground$lambda$1(this, currentProgress));
                bout.write(data2, 0, x);
            } while ((x = input.read(data2, 0, 1024)) >= 0);
            bout.close();
            input.close();
            fos.close();
        }
        catch (Exception e) {
            this.log.error(e.getLocalizedMessage());
        }
        return null;
    }

    @Override
    protected void done() {
        SwingUtilities.invokeLater(() -> DownloadWithProgressWorker.done$lambda$2(this));
        Path path = Paths.get(this.filename, new String[0]);
        Intrinsics.checkNotNullExpressionValue(path, "get(...)");
        this.finish.invoke(path);
    }

    private static final void doInBackground$lambda$0(DownloadWithProgressWorker this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.progressBar.setIndeterminate(false);
    }

    private static final void doInBackground$lambda$1(DownloadWithProgressWorker this$0, int $currentProgress) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.progressBar.setValue($currentProgress);
    }

    private static final void done$lambda$2(DownloadWithProgressWorker this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.progressBar.setIndeterminate(true);
    }
}

