/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.memory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.util.StringUtils;

public final class TernarySearchTree<Value> {
    private static final char WILDCARD = '?';
    private final ReadWriteLock lock;
    private final AtomicInteger size = new AtomicInteger(0);
    private Node<Value> root;

    private static void validateKey(String key) {
        if (StringUtils.isEmptyOrNull(key)) {
            throw new IllegalArgumentException(JGitText.get().illegalTernarySearchTreeKey);
        }
    }

    private static <V> void validateValue(V value) {
        if (value == null) {
            throw new IllegalArgumentException(JGitText.get().illegalTernarySearchTreeValue);
        }
    }

    public TernarySearchTree() {
        this.lock = new ReentrantReadWriteLock();
    }

    public ReadWriteLock getLock() {
        return this.lock;
    }

    public int replace(Iterable<Map.Entry<String, Value>> loader) {
        this.lock.writeLock().lock();
        try {
            this.clear();
            for (Map.Entry<String, Value> e : loader) {
                this.insertImpl(e.getKey(), e.getValue());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return this.size.get();
    }

    public int reload(Iterable<Map.Entry<String, Value>> loader) {
        this.lock.writeLock().lock();
        try {
            for (Map.Entry<String, Value> e : loader) {
                this.insertImpl(e.getKey(), e.getValue());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return this.size.get();
    }

    public int delete(Iterable<String> delete) {
        this.lock.writeLock().lock();
        try {
            for (String s : delete) {
                this.delete(s);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return this.size.get();
    }

    public int size() {
        return this.size.get();
    }

    @Nullable
    public Value get(String key) {
        TernarySearchTree.validateKey(key);
        this.lock.readLock().lock();
        try {
            Node<Value> node = this.get(this.root, key, 0);
            if (node == null) {
                return null;
            }
            Object Value2 = node.val;
            return Value2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean contains(String key) {
        return this.get(key) != null;
    }

    public int insert(String key, Value value) {
        this.lock.writeLock().lock();
        try {
            this.insertImpl(key, value);
            int n = this.size.get();
            return n;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public int insert(Map<String, Value> map) {
        this.lock.writeLock().lock();
        try {
            for (Map.Entry<String, Value> e : map.entrySet()) {
                this.insertImpl(e.getKey(), e.getValue());
            }
            int n = this.size.get();
            return n;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void insertImpl(String key, Value value) {
        TernarySearchTree.validateValue(value);
        if (!this.contains(key)) {
            this.size.addAndGet(1);
        }
        this.root = this.insert(this.root, key, value, 0);
    }

    public int delete(String key) {
        this.lock.writeLock().lock();
        try {
            if (this.contains(key)) {
                this.size.addAndGet(-1);
                this.root = this.insert(this.root, key, null, 0);
            }
            int n = this.size.get();
            return n;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.size.set(0);
            this.root = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Nullable
    public String keyLongestPrefixOf(String query) {
        if (StringUtils.isEmptyOrNull(query)) {
            return null;
        }
        this.lock.readLock().lock();
        try {
            int length = 0;
            Node<Value> node = this.root;
            int i = 0;
            while (node != null && i < query.length()) {
                char c = query.charAt(i);
                if (node.c > c) {
                    node = node.lo;
                    continue;
                }
                if (node.c < c) {
                    node = node.hi;
                    continue;
                }
                ++i;
                if (node.hasValue()) {
                    length = i;
                }
                node = node.eq;
            }
            String string = query.substring(0, length);
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Iterable<String> getKeys() {
        LinkedList<String> queue = new LinkedList<String>();
        this.lock.readLock().lock();
        try {
            this.findKeysWithPrefix(this.root, new StringBuilder(), queue);
            LinkedList<String> linkedList = queue;
            return linkedList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Iterable<String> getKeysWithPrefix(String prefix) {
        LinkedList<String> keys2 = new LinkedList<String>();
        if (prefix == null) {
            return keys2;
        }
        if (prefix.isEmpty()) {
            return this.getKeys();
        }
        this.lock.readLock().lock();
        try {
            TernarySearchTree.validateKey(prefix);
            Node<Value> node = this.get(this.root, prefix, 0);
            if (node == null) {
                LinkedList<String> linkedList = keys2;
                return linkedList;
            }
            if (node.hasValue()) {
                keys2.add(prefix);
            }
            this.findKeysWithPrefix(node.eq, new StringBuilder(prefix), keys2);
            LinkedList<String> linkedList = keys2;
            return linkedList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Map<String, Value> getAll() {
        HashMap entries = new HashMap();
        this.lock.readLock().lock();
        try {
            this.findWithPrefix(this.root, new StringBuilder(), entries);
            HashMap hashMap = entries;
            return hashMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<Value> getAllValues() {
        ArrayList values2 = new ArrayList();
        this.lock.readLock().lock();
        try {
            this.findValuesWithPrefix(this.root, new StringBuilder(), values2);
            ArrayList arrayList = values2;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Map<String, Value> getWithPrefix(String prefix) {
        HashMap entries = new HashMap();
        if (prefix == null) {
            return entries;
        }
        if (prefix.isEmpty()) {
            return this.getAll();
        }
        this.lock.readLock().lock();
        try {
            TernarySearchTree.validateKey(prefix);
            Node<Value> node = this.get(this.root, prefix, 0);
            if (node == null) {
                HashMap hashMap = entries;
                return hashMap;
            }
            if (node.hasValue()) {
                entries.put(prefix, node.val);
            }
            this.findWithPrefix(node.eq, new StringBuilder(prefix), entries);
            HashMap hashMap = entries;
            return hashMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<Value> getValuesWithPrefix(String prefix) {
        ArrayList values2 = new ArrayList();
        if (prefix == null) {
            return values2;
        }
        if (prefix.isEmpty()) {
            return this.getAllValues();
        }
        this.lock.readLock().lock();
        try {
            TernarySearchTree.validateKey(prefix);
            Node<Value> node = this.get(this.root, prefix, 0);
            if (node == null) {
                ArrayList arrayList = values2;
                return arrayList;
            }
            if (node.hasValue()) {
                values2.add(node.val);
            }
            this.findValuesWithPrefix(node.eq, new StringBuilder(prefix), values2);
            ArrayList arrayList = values2;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Iterable<String> getKeysMatching(String pattern) {
        LinkedList<String> keys2 = new LinkedList<String>();
        this.lock.readLock().lock();
        try {
            this.findKeysWithPrefix(this.root, new StringBuilder(), 0, pattern, keys2);
            LinkedList<String> linkedList = keys2;
            return linkedList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private Node<Value> get(Node<Value> node, String key, int depth) {
        if (node == null) {
            return null;
        }
        char c = key.charAt(depth);
        if (node.c > c) {
            return this.get(node.lo, key, depth);
        }
        if (node.c < c) {
            return this.get(node.hi, key, depth);
        }
        if (depth < key.length() - 1) {
            return this.get(node.eq, key, depth + 1);
        }
        return node;
    }

    private Node<Value> insert(Node<Value> node, String key, Value val, int depth) {
        char c = key.charAt(depth);
        if (node == null) {
            node = new Node(c);
        }
        if (node.c > c) {
            node.lo = this.insert(node.lo, key, val, depth);
        } else if (node.c < c) {
            node.hi = this.insert(node.hi, key, val, depth);
        } else if (depth < key.length() - 1) {
            node.eq = this.insert(node.eq, key, val, depth + 1);
        } else {
            node.val = val;
        }
        return node;
    }

    private void findKeysWithPrefix(Node<Value> node, StringBuilder prefix, Queue<String> keys2) {
        if (node == null) {
            return;
        }
        this.findKeysWithPrefix(node.lo, prefix, keys2);
        if (node.hasValue()) {
            keys2.add(String.valueOf(prefix.toString()) + node.c);
        }
        this.findKeysWithPrefix(node.eq, prefix.append(node.c), keys2);
        prefix.deleteCharAt(prefix.length() - 1);
        this.findKeysWithPrefix(node.hi, prefix, keys2);
    }

    private void findWithPrefix(Node<Value> node, StringBuilder prefix, Map<String, Value> entries) {
        if (node == null) {
            return;
        }
        this.findWithPrefix(node.lo, prefix, entries);
        if (node.hasValue()) {
            entries.put(String.valueOf(prefix.toString()) + node.c, node.val);
        }
        this.findWithPrefix(node.eq, prefix.append(node.c), entries);
        prefix.deleteCharAt(prefix.length() - 1);
        this.findWithPrefix(node.hi, prefix, entries);
    }

    private void findValuesWithPrefix(Node<Value> node, StringBuilder prefix, List<Value> values2) {
        if (node == null) {
            return;
        }
        this.findValuesWithPrefix(node.lo, prefix, values2);
        if (node.hasValue()) {
            values2.add(node.val);
        }
        this.findValuesWithPrefix(node.eq, prefix.append(node.c), values2);
        prefix.deleteCharAt(prefix.length() - 1);
        this.findValuesWithPrefix(node.hi, prefix, values2);
    }

    private void findKeysWithPrefix(Node<Value> node, StringBuilder prefix, int i, String pattern, Queue<String> keys2) {
        if (node == null || StringUtils.isEmptyOrNull(pattern)) {
            return;
        }
        char c = pattern.charAt(i);
        if (c == '?' || node.c > c) {
            this.findKeysWithPrefix(node.lo, prefix, i, pattern, keys2);
        }
        if (c == '?' || node.c == c) {
            if (i == pattern.length() - 1 && node.hasValue()) {
                keys2.add(String.valueOf(prefix.toString()) + node.c);
            }
            if (i < pattern.length() - 1) {
                this.findKeysWithPrefix(node.eq, prefix.append(node.c), i + 1, pattern, keys2);
                prefix.deleteCharAt(prefix.length() - 1);
            }
        }
        if (c == '?' || node.c < c) {
            this.findKeysWithPrefix(node.hi, prefix, i, pattern, keys2);
        }
    }

    public static interface Loader<Value> {
        public Map<String, Value> loadAll();
    }

    private static class Node<Value> {
        final char c;
        Node<Value> lo;
        Node<Value> eq;
        Node<Value> hi;
        Value val;

        Node(char c) {
            this.c = c;
        }

        boolean hasValue() {
            return this.val != null;
        }
    }
}

