/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client.extensions.openssh;

import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.sftp.SftpModuleProperties;

public class OpenSSHLimitsExtensionInfo
implements Cloneable {
    public long maxPacketLength;
    public long maxReadLength;
    public long maxWriteLength;
    public long maxOpenHandles;

    public OpenSSHLimitsExtensionInfo() {
    }

    public OpenSSHLimitsExtensionInfo(Buffer buffer) {
        OpenSSHLimitsExtensionInfo.decode(buffer, this);
    }

    public OpenSSHLimitsExtensionInfo(PropertyResolver resolver) {
        OpenSSHLimitsExtensionInfo.fill(resolver, this);
    }

    public <B extends Buffer> B encode(B buffer) {
        return OpenSSHLimitsExtensionInfo.encode(buffer, this);
    }

    public int hashCode() {
        return NumberUtils.hashCode(this.maxPacketLength, this.maxReadLength, this.maxWriteLength, this.maxOpenHandles);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OpenSSHLimitsExtensionInfo other = (OpenSSHLimitsExtensionInfo)obj;
        return this.maxPacketLength == other.maxPacketLength && this.maxReadLength == other.maxReadLength && this.maxWriteLength == other.maxWriteLength && this.maxOpenHandles == other.maxOpenHandles;
    }

    public OpenSSHLimitsExtensionInfo clone() {
        try {
            return (OpenSSHLimitsExtensionInfo)this.getClass().cast(super.clone());
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to close " + this.toString() + ": " + e.getMessage());
        }
    }

    public String toString() {
        return "maxPacketLength=" + this.maxPacketLength + ", maxReadLength=" + this.maxReadLength + ", maxWriteLength=" + this.maxWriteLength + ", maxOpenHandles=" + this.maxOpenHandles;
    }

    public static <B extends Buffer> B encode(B buffer, OpenSSHLimitsExtensionInfo info) {
        buffer.putLong(info.maxPacketLength);
        buffer.putLong(info.maxReadLength);
        buffer.putLong(info.maxWriteLength);
        buffer.putLong(info.maxOpenHandles);
        return buffer;
    }

    public static <I extends OpenSSHLimitsExtensionInfo> I decode(Buffer buffer, I info) {
        info.maxPacketLength = buffer.getLong();
        info.maxReadLength = buffer.getLong();
        info.maxWriteLength = buffer.getLong();
        info.maxOpenHandles = buffer.getLong();
        return info;
    }

    public static <I extends OpenSSHLimitsExtensionInfo> I fill(PropertyResolver resolver, I info) {
        info.maxReadLength = SftpModuleProperties.MAX_READDATA_PACKET_LENGTH.getRequired(resolver).intValue();
        info.maxWriteLength = SftpModuleProperties.MAX_WRITEDATA_PACKET_LENGTH.getRequired(resolver).intValue();
        info.maxPacketLength = Math.max(info.maxReadLength, info.maxWriteLength) + 5L + 12L;
        info.maxOpenHandles = SftpModuleProperties.MAX_OPEN_HANDLES_PER_SESSION.getRequired(resolver).intValue();
        if (info.maxOpenHandles >= 0x7FFFFFFEL) {
            info.maxOpenHandles = 0L;
        }
        return info;
    }
}

