/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.keyprovider;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.sshd.common.keyprovider.MultiKeyIdentityIterator;
import org.apache.sshd.common.keyprovider.MultiKeyIdentityProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.functors.UnaryEquator;

@FunctionalInterface
public interface KeyIdentityProvider {
    public static final KeyIdentityProvider EMPTY_KEYS_PROVIDER = new KeyIdentityProvider(){

        @Override
        public Iterable<KeyPair> loadKeys(SessionContext session) {
            return Collections.emptyList();
        }

        public String toString() {
            return "EMPTY";
        }
    };

    public Iterable<KeyPair> loadKeys(SessionContext var1) throws IOException, GeneralSecurityException;

    public static boolean isEmpty(KeyIdentityProvider provider) {
        return provider == null || UnaryEquator.isSameReference(provider, EMPTY_KEYS_PROVIDER);
    }

    public static KeyIdentityProvider resolveKeyIdentityProvider(KeyIdentityProvider identities, KeyIdentityProvider keys2) {
        if (KeyIdentityProvider.isEmpty(keys2) || UnaryEquator.isSameReference(identities, keys2)) {
            return identities == null ? keys2 : identities;
        }
        if (KeyIdentityProvider.isEmpty(identities)) {
            return keys2;
        }
        return KeyIdentityProvider.multiProvider(identities, keys2);
    }

    public static KeyIdentityProvider multiProvider(KeyIdentityProvider ... providers) {
        return KeyIdentityProvider.multiProvider(GenericUtils.asList(providers));
    }

    public static KeyIdentityProvider multiProvider(Collection<? extends KeyIdentityProvider> providers) {
        int numProviders = GenericUtils.size(providers);
        if (numProviders <= 0) {
            return EMPTY_KEYS_PROVIDER;
        }
        if (numProviders == 1) {
            return GenericUtils.head(providers);
        }
        return new MultiKeyIdentityProvider(providers);
    }

    public static Iterable<KeyPair> iterableOf(final SessionContext session, final Collection<? extends KeyIdentityProvider> providers) {
        int numProviders = GenericUtils.size(providers);
        if (numProviders <= 0) {
            return Collections.emptyList();
        }
        if (numProviders == 1) {
            KeyIdentityProvider p = GenericUtils.head(providers);
            try {
                return p.loadKeys(session);
            }
            catch (IOException | GeneralSecurityException e) {
                throw new RuntimeException("Unexpected " + e.getClass().getSimpleName() + ") keys loading exception: " + e.getMessage(), e);
            }
        }
        return new Iterable<KeyPair>(){

            @Override
            public Iterator<KeyPair> iterator() {
                return new MultiKeyIdentityIterator(session, providers);
            }

            public String toString() {
                return Iterable.class.getSimpleName() + "[of(providers)]";
            }
        };
    }

    public static KeyIdentityProvider wrapKeyPairs(KeyPair ... pairs) {
        return KeyIdentityProvider.wrapKeyPairs(GenericUtils.asList(pairs));
    }

    public static KeyIdentityProvider wrapKeyPairs(Iterable<KeyPair> pairs) {
        return pairs == null ? EMPTY_KEYS_PROVIDER : session -> pairs;
    }

    public static KeyPair exhaustCurrentIdentities(Iterator<KeyPair> ids) {
        while (ids != null && ids.hasNext()) {
            KeyPair kp = ids.next();
            if (kp == null) continue;
            return kp;
        }
        return null;
    }
}

