/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.name;

import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CallableId {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final FqName packageName;
    @Nullable
    private final FqName className;
    @NotNull
    private final Name callableName;
    @Nullable
    private final FqName pathToLocal;
    @Deprecated
    @NotNull
    private static final Name LOCAL_NAME;
    @Deprecated
    @NotNull
    private static final FqName PACKAGE_FQ_NAME_FOR_LOCAL;

    public CallableId(@NotNull FqName packageName, @Nullable FqName className, @NotNull Name callableName, @Nullable FqName pathToLocal) {
        Intrinsics.checkNotNullParameter(packageName, "packageName");
        Intrinsics.checkNotNullParameter(callableName, "callableName");
        this.packageName = packageName;
        this.className = className;
        this.callableName = callableName;
        this.pathToLocal = pathToLocal;
    }

    public /* synthetic */ CallableId(FqName fqName2, FqName fqName3, Name name, FqName fqName4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            fqName4 = null;
        }
        this(fqName2, fqName3, name, fqName4);
    }

    @NotNull
    public final FqName getPackageName() {
        return this.packageName;
    }

    @Nullable
    public final FqName getClassName() {
        return this.className;
    }

    @NotNull
    public final Name getCallableName() {
        return this.callableName;
    }

    public CallableId(@NotNull FqName packageName, @NotNull Name callableName) {
        Intrinsics.checkNotNullParameter(packageName, "packageName");
        Intrinsics.checkNotNullParameter(callableName, "callableName");
        this(packageName, null, callableName, null, 8, null);
    }

    @NotNull
    public String toString() {
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$toString_u24lambda_u2d0 = stringBuilder;
        boolean bl5 = false;
        String string = this.getPackageName().asString();
        Intrinsics.checkNotNullExpressionValue(string, "packageName.asString()");
        $this$toString_u24lambda_u2d0.append(StringsKt.replace$default(string, '.', '/', false, 4, null));
        $this$toString_u24lambda_u2d0.append("/");
        if (this.getClassName() != null) {
            $this$toString_u24lambda_u2d0.append(this.getClassName());
            $this$toString_u24lambda_u2d0.append(".");
        }
        $this$toString_u24lambda_u2d0.append(this.getCallableName());
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    public int hashCode() {
        int result2 = this.packageName.hashCode();
        result2 = result2 * 31 + (this.className == null ? 0 : this.className.hashCode());
        result2 = result2 * 31 + this.callableName.hashCode();
        result2 = result2 * 31 + (this.pathToLocal == null ? 0 : this.pathToLocal.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CallableId)) {
            return false;
        }
        CallableId callableId = (CallableId)other;
        if (!Intrinsics.areEqual(this.packageName, callableId.packageName)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.className, callableId.className)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.callableName, callableId.callableName)) {
            return false;
        }
        return Intrinsics.areEqual(this.pathToLocal, callableId.pathToLocal);
    }

    static {
        Object object = Name.special("<local>");
        Intrinsics.checkNotNullExpressionValue(object, "special(\"<local>\")");
        LOCAL_NAME = object;
        object = FqName.topLevel(LOCAL_NAME);
        Intrinsics.checkNotNullExpressionValue(object, "topLevel(LOCAL_NAME)");
        PACKAGE_FQ_NAME_FOR_LOCAL = object;
    }

    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

