/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.types;

import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.attributes.names.FuncLink;
import de.peeeq.wurstscript.jassIm.ImExprOpt;
import de.peeeq.wurstscript.jassIm.ImType;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import de.peeeq.wurstscript.types.VariableBinding;
import de.peeeq.wurstscript.types.VariablePosition;
import de.peeeq.wurstscript.types.WurstTypeArray;
import de.peeeq.wurstscript.types.WurstTypeBoundTypeParam;
import de.peeeq.wurstscript.types.WurstTypeClass;
import de.peeeq.wurstscript.types.WurstTypeClassOrInterface;
import de.peeeq.wurstscript.types.WurstTypeEnum;
import de.peeeq.wurstscript.types.WurstTypeInfer;
import de.peeeq.wurstscript.types.WurstTypeInt;
import de.peeeq.wurstscript.types.WurstTypeIntLiteral;
import de.peeeq.wurstscript.types.WurstTypeModule;
import de.peeeq.wurstscript.types.WurstTypeNamedScope;
import de.peeeq.wurstscript.types.WurstTypeNull;
import de.peeeq.wurstscript.types.WurstTypeTypeParam;
import de.peeeq.wurstscript.types.WurstTypeUnion;
import de.peeeq.wurstscript.types.WurstTypeUnknown;
import io.vavr.control.Option;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.Nullable;

public abstract class WurstType {
    public final boolean isSubtypeOf(WurstType other, @Nullable Element location) {
        return this.matchAgainstSupertype(other, location, VariableBinding.emptyMapping(), VariablePosition.RIGHT) != null;
    }

    public final @Nullable VariableBinding matchAgainstSupertype(WurstType other, @Nullable Element location, VariableBinding mapping, VariablePosition variablePosition) {
        if (other instanceof WurstTypeUnknown || this instanceof WurstTypeUnknown) {
            return mapping;
        }
        if (other instanceof WurstTypeInfer || this instanceof WurstTypeInfer) {
            return mapping;
        }
        if (other instanceof WurstTypeBoundTypeParam) {
            WurstTypeBoundTypeParam btp = (WurstTypeBoundTypeParam)other;
            return this.matchAgainstSupertype(btp.getBaseType(), location, mapping, VariablePosition.NONE);
        }
        if (other instanceof WurstTypeUnion) {
            WurstTypeUnion wtu = (WurstTypeUnion)other;
            mapping = this.matchAgainstSupertype(wtu.getTypeA(), location, mapping, variablePosition);
            if (mapping == null) {
                return null;
            }
            return this.matchAgainstSupertype(wtu.getTypeB(), location, mapping, variablePosition);
        }
        if (other instanceof WurstTypeTypeParam) {
            WurstTypeTypeParam this2;
            WurstTypeTypeParam tp = (WurstTypeTypeParam)other;
            if (variablePosition == VariablePosition.RIGHT) {
                Option<WurstTypeBoundTypeParam> bound = mapping.get(tp.getDef());
                if (bound.isDefined()) {
                    return this.matchAgainstSupertype((WurstType)bound.get(), location, mapping, variablePosition);
                }
                if (mapping.isVar(tp.getDef())) {
                    return mapping.set(tp.getDef(), new WurstTypeBoundTypeParam(tp.getDef(), this, location));
                }
            }
            if (this instanceof WurstTypeTypeParam && (this2 = (WurstTypeTypeParam)this).getDef() == tp.getDef()) {
                return mapping;
            }
        }
        return this.matchAgainstSupertypeIntern(other, location, mapping, variablePosition);
    }

    abstract VariableBinding matchAgainstSupertypeIntern(WurstType var1, @Nullable Element var2, VariableBinding var3, VariablePosition var4);

    public final boolean isSupertypeOf(WurstType other, Element location) {
        return other.isSubtypeOf(this, location);
    }

    public abstract String getName();

    public abstract String getFullName();

    public boolean equalsType(WurstType otherType, @Nullable Element location) {
        return this.matchTypes(otherType, location, VariableBinding.emptyMapping(), VariablePosition.RIGHT) != null;
    }

    public VariableBinding matchTypes(WurstType otherType, @Nullable Element location, VariableBinding mapping, VariablePosition variablePosition) {
        if ((mapping = this.matchAgainstSupertype(otherType, location, mapping, variablePosition)) == null) {
            return null;
        }
        return otherType.matchAgainstSupertype(this, location, mapping, variablePosition.inverse());
    }

    public String toString() {
        return this.getName();
    }

    @Deprecated
    public boolean equals(@Nullable Object other) {
        throw new Error("operation not supported");
    }

    @Deprecated
    public int hashCode() {
        throw new Error("Hash code not implemented for types, because it could conflict with the custom equals operation.");
    }

    public WurstType dynamic() {
        return this;
    }

    public WurstType setTypeArgs(VariableBinding typeParamMapping) {
        return this;
    }

    public VariableBinding getTypeArgBinding() {
        return VariableBinding.emptyMapping();
    }

    public abstract ImType imTranslateType(ImTranslator var1);

    public abstract ImExprOpt getDefaultValue(ImTranslator var1);

    public boolean isVoid() {
        return false;
    }

    public boolean canBeUsedInInstanceOf() {
        return false;
    }

    public boolean allowsDynamicDispatch() {
        return false;
    }

    public void addMemberMethods(Element node, String name, List<FuncLink> result) {
    }

    public Stream<FuncLink> getMemberMethods(Element node) {
        return Stream.empty();
    }

    public boolean isStaticRef() {
        return false;
    }

    public boolean isTranslatedToInt() {
        return this instanceof WurstTypeInt || this instanceof WurstTypeIntLiteral || this instanceof WurstTypeNamedScope || this instanceof WurstTypeTypeParam || this instanceof WurstTypeNull || this instanceof WurstTypeBoundTypeParam;
    }

    public boolean isCastableToInt() {
        return this instanceof WurstTypeClass || this instanceof WurstTypeModule || this instanceof WurstTypeClassOrInterface || this instanceof WurstTypeTypeParam || this instanceof WurstTypeBoundTypeParam || this instanceof WurstTypeEnum;
    }

    public WurstType normalize() {
        return this;
    }

    public boolean supportsGenerics() {
        WurstType t = this.normalize();
        return t instanceof WurstTypeNamedScope || t instanceof WurstTypeNull || t instanceof WurstTypeInt || t instanceof WurstTypeTypeParam || t instanceof WurstTypeIntLiteral;
    }

    public WurstType typeUnion(WurstType t, Element loc) {
        return WurstTypeUnion.create(this, t, loc);
    }

    public boolean isNestedInside(WurstType other) {
        return false;
    }

    protected abstract boolean isNullable();

    public boolean isArray() {
        return this instanceof WurstTypeArray;
    }

    public String toPrettyString() {
        return this.toString();
    }
}

