/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.immutablecollections;

import com.google.common.base.Preconditions;
import de.peeeq.immutablecollections.ImmutableList;
import de.peeeq.immutablecollections.ImmutableListImplCons;
import de.peeeq.immutablecollections.ImmutableListIterator;
import java.util.Iterator;

class ImmutableListImpl<T>
extends ImmutableList<T> {
    private final T head;
    private final ImmutableList<T> tail;
    private final int size;

    ImmutableListImpl(T elem) {
        this.head = elem;
        this.tail = ImmutableList.emptyList();
        this.size = 1;
    }

    ImmutableListImpl(T head, ImmutableList<T> tail) {
        this.head = head;
        this.tail = tail;
        this.size = 1 + tail.size();
    }

    @Override
    public Iterator<T> iterator() {
        return new ImmutableListIterator(this);
    }

    @Override
    public ImmutableList<T> appFront(T elem) {
        Preconditions.checkNotNull(elem);
        return new ImmutableListImpl<T>(elem, this);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public T head() {
        return this.head;
    }

    @Override
    public ImmutableList<T> tail() {
        return this.tail;
    }

    @Override
    public <R extends T> ImmutableList<T> cons(ImmutableList<R> other) {
        if (other.isEmpty()) {
            return this;
        }
        return new ImmutableListImplCons(this, other);
    }

    @Override
    public ImmutableList<T> removeAll(T t) {
        if (this.head.equals(t)) {
            return this.tail.removeAll(t);
        }
        return this.tail.removeAll(t).appFront(this.head);
    }
}

