/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.types;

import de.peeeq.wurstscript.ast.TypeParamDef;
import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.types.WurstTypeBoundTypeParam;
import io.vavr.Tuple2;
import io.vavr.collection.HashMap;
import io.vavr.collection.List;
import io.vavr.collection.Set;
import io.vavr.control.Option;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class VariableBinding
implements Iterable<Tuple2<TypeParamDef, WurstTypeBoundTypeParam>> {
    public static final VariableBinding EMPTY_MAPPING = new VariableBinding((HashMap<TypeParamDef, WurstTypeBoundTypeParam>)HashMap.empty(), (List<TypeParamDef>)List.empty(), (List<CompileError>)List.empty());
    private final HashMap<TypeParamDef, WurstTypeBoundTypeParam> binding;
    private final List<TypeParamDef> typeVariablesLeft;
    private final List<CompileError> errors;

    public VariableBinding(HashMap<TypeParamDef, WurstTypeBoundTypeParam> binding, List<TypeParamDef> typeVariablesLeft, List<CompileError> errors) {
        this.binding = binding;
        this.typeVariablesLeft = typeVariablesLeft;
        this.errors = errors;
    }

    @NotNull
    public static VariableBinding emptyMapping() {
        return EMPTY_MAPPING;
    }

    public boolean contains(TypeParamDef v) {
        return this.binding.containsKey((Object)v);
    }

    public Option<WurstTypeBoundTypeParam> get(TypeParamDef v) {
        return this.binding.get((Object)v);
    }

    public VariableBinding set(TypeParamDef v, WurstTypeBoundTypeParam b) {
        return new VariableBinding((HashMap<TypeParamDef, WurstTypeBoundTypeParam>)this.binding.put((Object)v, (Object)b), (List<TypeParamDef>)this.typeVariablesLeft.removeAll(v::equals), this.errors);
    }

    public boolean isEmpty() {
        return this.binding.isEmpty();
    }

    public VariableBinding union(VariableBinding other) {
        if (this.isEmpty() && this.errors.isEmpty()) {
            return other;
        }
        if (other.isEmpty() && other.errors.isEmpty()) {
            return this;
        }
        VariableBinding res = new VariableBinding(this.binding, this.typeVariablesLeft, (List<CompileError>)this.errors.appendAll(other.errors));
        for (Tuple2 e : other.binding) {
            res = res.set((TypeParamDef)e._1(), (WurstTypeBoundTypeParam)e._2());
        }
        return res;
    }

    public Set<TypeParamDef> keys() {
        return this.binding.keySet();
    }

    @Override
    @NotNull
    public Iterator<Tuple2<TypeParamDef, WurstTypeBoundTypeParam>> iterator() {
        return this.binding.iterator();
    }

    public String toString() {
        boolean first;
        StringBuilder s = new StringBuilder();
        if (this.hasUnboundTypeVars()) {
            s.append("<");
            first = true;
            for (TypeParamDef t : this.typeVariablesLeft) {
                if (!first) {
                    s.append(", ");
                }
                s.append(t.getName()).append(" line ").append(t.getSource().getLine());
                first = false;
            }
            s.append(">");
        }
        s.append("[");
        first = true;
        for (Tuple2 e : this.binding) {
            if (!first) {
                s.append(", ");
            }
            s.append(((TypeParamDef)e._1()).getName());
            s.append(" -> ");
            s.append(((WurstTypeBoundTypeParam)e._2()).getBaseType());
            first = false;
        }
        s.append("]");
        if (!this.errors.isEmpty()) {
            s.append("{");
            for (CompileError error : this.errors) {
                s.append(error);
            }
            s.append("}");
        }
        return s.toString();
    }

    public VariableBinding withTypeVariables(Iterable<TypeParamDef> vars) {
        return new VariableBinding(this.binding, (List<TypeParamDef>)this.typeVariablesLeft.appendAll(vars), this.errors);
    }

    public boolean isVar(TypeParamDef def) {
        return this.typeVariablesLeft.exists(def::equals);
    }

    public boolean hasUnboundTypeVars() {
        return !this.typeVariablesLeft.isEmpty();
    }

    public String printUnboundTypeVars() {
        StringBuilder res = new StringBuilder();
        for (TypeParamDef t : this.typeVariablesLeft) {
            if (res.length() > 0) {
                res.append(", ");
            }
            res.append(t.getName());
        }
        return res.toString();
    }

    public VariableBinding withError(CompileError err) {
        return new VariableBinding(this.binding, this.typeVariablesLeft, (List<CompileError>)this.errors.prepend((Object)err));
    }

    public List<CompileError> getErrors() {
        return this.errors;
    }
}

