/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.attributes.names;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import de.peeeq.wurstscript.ast.AstElementWithTypeParameters;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.ExtensionFuncDef;
import de.peeeq.wurstscript.ast.FuncDef;
import de.peeeq.wurstscript.ast.FunctionDefinition;
import de.peeeq.wurstscript.ast.NameDef;
import de.peeeq.wurstscript.ast.TypeParamDef;
import de.peeeq.wurstscript.ast.WParameter;
import de.peeeq.wurstscript.ast.WScope;
import de.peeeq.wurstscript.attributes.names.DefLink;
import de.peeeq.wurstscript.attributes.names.NameLinkType;
import de.peeeq.wurstscript.attributes.names.Visibility;
import de.peeeq.wurstscript.parser.WPos;
import de.peeeq.wurstscript.types.VariableBinding;
import de.peeeq.wurstscript.types.WurstType;
import de.peeeq.wurstscript.types.WurstTypeVararg;
import de.peeeq.wurstscript.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;

public class FuncLink
extends DefLink {
    private final FunctionDefinition def;
    private final WurstType returnType;
    private final List<String> parameterNames;
    private final List<WurstType> parameterTypes;
    private final VariableBinding mapping;

    public FuncLink(Visibility visibility, WScope definedIn, List<TypeParamDef> typeParams, @Nullable WurstType receiverType, FunctionDefinition def, List<String> parameterNames, List<WurstType> parameterTypes, WurstType returnType, VariableBinding mapping) {
        super(visibility, definedIn, typeParams, receiverType);
        this.def = def;
        this.returnType = returnType;
        this.parameterTypes = parameterTypes;
        this.parameterNames = parameterNames;
        this.mapping = mapping;
    }

    public static FuncLink create(FunctionDefinition func, WScope definedIn) {
        Visibility visibiliy = FuncLink.calcVisibility(definedIn, func);
        List<TypeParamDef> typeParams = FuncLink.typeParams(func).collect(Collectors.toList());
        List<String> lParameterNames = func.getParameters().stream().map(WParameter::getName).collect(Collectors.toList());
        List<WurstType> lParameterTypes = func.getParameters().stream().map(WParameter::attrTyp).collect(Collectors.toList());
        WurstType lreturnType = func.attrReturnTyp();
        WurstType lreceiverType = FuncLink.calcReceiverType(definedIn, func);
        VariableBinding mapping = VariableBinding.emptyMapping();
        if (func instanceof AstElementWithTypeParameters) {
            mapping = mapping.withTypeVariables(((AstElementWithTypeParameters)((Object)func)).getTypeParameters());
        }
        return new FuncLink(visibiliy, definedIn, typeParams, lreceiverType, func, lParameterNames, lParameterTypes, lreturnType, mapping);
    }

    private static @Nullable WurstType calcReceiverType(WScope definedIn, NameDef nameDef) {
        if (nameDef instanceof ExtensionFuncDef) {
            ExtensionFuncDef exF = (ExtensionFuncDef)nameDef;
            return exF.getExtendedType().attrTyp().dynamic();
        }
        if (nameDef instanceof FuncDef) {
            return FuncLink.getReceiverType(definedIn);
        }
        return null;
    }

    @Override
    public String getName() {
        return this.def.getName();
    }

    @Override
    public FunctionDefinition getDef() {
        return this.def;
    }

    @Override
    public FuncLink withVisibility(Visibility newVis) {
        if (newVis == this.getVisibility()) {
            return this;
        }
        return new FuncLink(newVis, this.getDefinedIn(), this.getTypeParams(), this.getReceiverType(), this.def, this.parameterNames, this.parameterTypes, this.returnType, this.mapping);
    }

    public String getParameterDescription() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.getParameterTypes().size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.getParameterType(i));
            if (i >= this.getParameterNames().size()) continue;
            sb.append(" ");
            sb.append(this.getParameterName(i));
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append((Object)this.getVisibility());
        result.append(" ");
        if (this.getReceiverType() != null) {
            result.append(this.getReceiverType()).append(".");
        }
        result.append(this.getName());
        if (!this.typeParams.isEmpty()) {
            result.append("<");
            result.append(this.typeParams.stream().map(TypeParamDef::getName).collect(Collectors.joining(", ")));
            result.append(">");
        }
        result.append("(");
        result.append(this.getParameterDescription());
        result.append(") returns ");
        result.append(this.returnType);
        WPos src = this.def.attrSource();
        result.append(" (").append(src.getFile()).append(":").append(src.getLine()).append(")");
        return result.toString();
    }

    @Override
    public NameLinkType getType() {
        return NameLinkType.FUNCTION;
    }

    @Override
    public FuncLink withTypeArgBinding(Element context, VariableBinding binding) {
        ArrayList newParamTypes;
        boolean changed;
        if (binding.isEmpty()) {
            return this;
        }
        WurstType newReturnType = this.adjustType(context, this.getReturnType(), binding);
        boolean bl = changed = newReturnType != this.returnType;
        if (this.getParameterTypes().isEmpty()) {
            newParamTypes = this.getParameterTypes();
        } else {
            newParamTypes = Lists.newArrayListWithCapacity((int)this.getParameterTypes().size());
            for (WurstType pt : this.getParameterTypes()) {
                WurstType newPt = this.adjustType(context, pt, binding);
                if (newPt != pt) {
                    changed = true;
                }
                newParamTypes.add(newPt);
            }
        }
        WurstType newReceiverType = this.adjustType(context, this.getReceiverType(), binding);
        boolean bl2 = changed = changed || newReceiverType != this.getReceiverType();
        if (changed) {
            List<TypeParamDef> newTypeParams = this.getTypeParams().stream().filter(tp -> !binding.contains((TypeParamDef)tp)).collect(Collectors.toList());
            return new FuncLink(this.getVisibility(), this.getDefinedIn(), newTypeParams, newReceiverType, this.def, this.parameterNames, newParamTypes, newReturnType, binding);
        }
        return this;
    }

    @Override
    public DefLink withGenericTypeParams(List<TypeParamDef> typeParams) {
        if (typeParams.isEmpty()) {
            return this;
        }
        ImmutableList newTypeParams = Utils.concatLists(this.getTypeParams(), typeParams);
        return new FuncLink(this.getVisibility(), this.getDefinedIn(), (List<TypeParamDef>)newTypeParams, this.getReceiverType(), this.def, this.parameterNames, this.parameterTypes, this.returnType, this.mapping);
    }

    @Override
    public WurstType getTyp() {
        return this.getReturnType();
    }

    @Override
    public FuncLink withDef(NameDef def) {
        return new FuncLink(this.getVisibility(), this.getDefinedIn(), this.getTypeParams(), this.getReceiverType(), (FunctionDefinition)def, this.getParameterNames(), this.getParameterTypes(), this.getReturnType(), this.mapping);
    }

    private WurstType adjustType(Element context, WurstType t, VariableBinding binding) {
        if (t == null) {
            return null;
        }
        return t.setTypeArgs(binding);
    }

    public WurstType getReturnType() {
        return this.returnType;
    }

    public List<WurstType> getParameterTypes() {
        return this.parameterTypes;
    }

    public WurstType getParameterType(int i) {
        List<WurstType> parameterTypes = this.getParameterTypes();
        if (this.isVarargMethod() && i >= parameterTypes.size() - 1) {
            return ((WurstTypeVararg)parameterTypes.get(parameterTypes.size() - 1)).getBaseType();
        }
        return parameterTypes.get(i);
    }

    public String getParameterName(int i) {
        if (this.isVarargMethod() && i >= this.parameterNames.size() - 1) {
            return this.parameterNames.get(this.parameterNames.size() - 1);
        }
        return this.parameterNames.get(i);
    }

    public boolean isVarargMethod() {
        List<WurstType> parameterTypes = this.getParameterTypes();
        if (parameterTypes.size() > 0) {
            return parameterTypes.get(parameterTypes.size() - 1) instanceof WurstTypeVararg;
        }
        return false;
    }

    public FuncLink withConfigDef() {
        FunctionDefinition def = (FunctionDefinition)this.def.attrConfigActualNameDef();
        return new FuncLink(this.getVisibility(), this.getDefinedIn(), this.getTypeParams(), this.getReceiverType(), def, this.parameterNames, this.parameterTypes, this.returnType, this.mapping);
    }

    @Override
    public FuncLink hidingPrivate() {
        return (FuncLink)super.hidingPrivate();
    }

    @Override
    public FuncLink hidingPrivateAndProtected() {
        return (FuncLink)super.hidingPrivateAndProtected();
    }

    public List<String> getParameterNames() {
        return this.parameterNames;
    }

    @Override
    public FuncLink adaptToReceiverType(WurstType receiverType) {
        return (FuncLink)super.adaptToReceiverType(receiverType);
    }

    public String printFunctionTemplate() {
        StringBuilder res = new StringBuilder("function ");
        res.append(this.getName());
        res.append("(");
        for (int i = 0; i < this.parameterNames.size(); ++i) {
            if (i > 0) {
                res.append(", ");
            }
            res.append(this.parameterTypes.get(i));
            res.append(" ");
            res.append(this.parameterNames.get(i));
        }
        res.append(")");
        if (!this.getReturnType().isVoid()) {
            res.append(" returns ");
            res.append(this.getReturnType());
        }
        return res.toString();
    }

    public boolean isStatic() {
        return this.def.attrIsStatic();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FuncLink funcLink = (FuncLink)o;
        return Objects.equals(this.def, funcLink.def);
    }

    public int hashCode() {
        return Objects.hash(this.def);
    }

    public VariableBinding getVariableBinding() {
        return this.mapping;
    }

    public boolean hasIfNotDefinedAnnotation() {
        return this.def.attrHasAnnotation("ifNotDefined");
    }
}

