/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio.languageserver;

import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class DebouncingTimer {
    private final Runnable action;
    private final ScheduledExecutorService es = Executors.newSingleThreadScheduledExecutor();
    private boolean isReady = false;
    private ScheduledFuture<?> fut;

    public DebouncingTimer(Runnable action) {
        this.action = action;
    }

    public synchronized boolean isReady() {
        return this.isReady;
    }

    public synchronized void stop() {
        if (this.fut != null) {
            this.fut.cancel(true);
            this.fut = null;
        }
        this.isReady = false;
    }

    public synchronized void start(Duration d) {
        this.stop();
        this.fut = this.es.schedule(() -> {
            DebouncingTimer debouncingTimer = this;
            synchronized (debouncingTimer) {
                this.isReady = true;
            }
            this.action.run();
        }, d.toMillis(), TimeUnit.MILLISECONDS);
    }
}

