/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.datastructures;

import java.util.function.Function;
import java.util.function.Supplier;

public class Deferred<T> {
    private Supplier<T> supplier;
    private T value;

    public Deferred(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    public Deferred(T value) {
        this.value = value;
    }

    public T get() {
        if (this.supplier != null) {
            this.value = this.supplier.get();
            this.supplier = null;
        }
        return this.value;
    }

    public <S> Deferred<S> map(Function<T, S> f) {
        if (this.supplier == null) {
            S newValue = f.apply(this.value);
            if (newValue == this.value) {
                return this;
            }
            return new Deferred<S>(newValue);
        }
        return new Deferred<Supplier<Object>>(() -> f.apply(this.get()));
    }
}

