/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.bin.app;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Format;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.misc.Id;

public class MapFooter {
    public static final Id START_TOKEN = Id.valueOf("NGIS");
    public static final int DATA_SIZE = 256;
    private byte[] _data;

    public byte[] getData() {
        return Arrays.copyOf(this._data, 256);
    }

    public void setData(byte[] data) {
        this._data = Arrays.copyOf(data, 256);
    }

    public void writeToMapFile(@Nonnull File file) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        Wc3BinOutputStream stream = new Wc3BinOutputStream(byteStream);
        Writer writer = new Writer(stream);
        writer.exec(this);
        stream.close();
        byte[] bytes = byteStream.toByteArray();
        RandomAccessFile fp = new RandomAccessFile(file, "r");
        fp.seek(fp.length() - 256L - 4L);
        byte[] startTokenBytes = new byte[4];
        fp.read(startTokenBytes, 0, startTokenBytes.length);
        fp.close();
        Id startToken = Id.valueOf(new String(startTokenBytes, StandardCharsets.US_ASCII));
        fp = new RandomAccessFile(file, "rw");
        if (startToken.equals(START_TOKEN)) {
            fp.seek(fp.length() - 256L - 4L);
        } else {
            fp.seek(fp.length());
        }
        fp.write(bytes);
        fp.close();
    }

    public static MapFooter ofMapFile(@Nonnull File file) throws IOException {
        RandomAccessFile fp = new RandomAccessFile(file, "r");
        fp.seek(fp.length() - 256L - 4L);
        byte[] bytes = new byte[260];
        fp.read(bytes);
        fp.close();
        Wc3BinInputStream stream = new Wc3BinInputStream(new ByteArrayInputStream(bytes));
        Reader reader = new Reader(stream);
        MapFooter mapFooter = reader.exec();
        stream.close();
        return mapFooter;
    }

    public static MapFooter ofFile(@Nonnull File file) throws IOException {
        Wc3BinInputStream stream = new Wc3BinInputStream(file);
        Reader reader = new Reader(stream);
        MapFooter mapFooter = reader.exec();
        stream.close();
        return mapFooter;
    }

    public static class Reader
    extends net.moonlightflower.wc3libs.bin.Reader<EncodingFormat> {
        private MapFooter _mapFooter;

        public Reader(@Nonnull Wc3BinInputStream stream) {
            super(stream);
        }

        @Override
        public EncodingFormat getAutoFormat() {
            return EncodingFormat.AUTO;
        }

        @Nonnull
        public MapFooter exec() throws IOException {
            return this.exec(new MapFooter());
        }

        private MapFooter exec(@Nonnull MapFooter mapFooter) throws IOException {
            this._mapFooter = mapFooter;
            this.read((EncodingFormat)this.getFormat());
            return this._mapFooter;
        }

        @Nonnull
        private MapFooter read(@Nonnull EncodingFormat format) throws IOException {
            switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                case AUTO: {
                    return this.read_auto();
                }
                case MAP_FOOTER_0x0: {
                    return this.read_0x0();
                }
            }
            throw new Format.InvalidFormatException(format);
        }

        @Nonnull
        private MapFooter read_0x0() throws BinStream.StreamException {
            Wc3BinInputStream stream = this.getStream();
            Id startToken = stream.readId("startToken");
            if (!startToken.equals(START_TOKEN)) {
                throw new IllegalArgumentException("wrong startToken " + startToken);
            }
            this._mapFooter._data = Arrays.copyOf(stream.readBytes(256), 256);
            return this._mapFooter;
        }

        @Nonnull
        private MapFooter read_auto() throws IOException {
            return this.read_0x0();
        }
    }

    public static class Writer
    extends net.moonlightflower.wc3libs.bin.Writer<EncodingFormat> {
        private MapFooter _mapFooter;

        @Override
        public EncodingFormat getAutoFormat() {
            return EncodingFormat.AUTO;
        }

        private void write_0x0(@Nonnull Wc3BinOutputStream stream) throws BinStream.StreamException {
            long startPos = stream.getPos();
            stream.writeId(START_TOKEN);
            byte[] data = Arrays.copyOf(this._mapFooter._data, 256);
            stream.writeBytes(data);
        }

        public void exec(@Nonnull MapFooter mapFooter) throws BinStream.StreamException {
            this._mapFooter = mapFooter;
            switch ((EncodingFormat.Enum)((Object)((EncodingFormat)this.getFormat()).toEnum())) {
                case AUTO: 
                case MAP_FOOTER_0x0: {
                    this.write_0x0(this.getStream());
                }
            }
        }

        public Writer(@Nonnull Wc3BinOutputStream stream) {
            super(stream);
        }
    }

    public static class EncodingFormat
    extends Format<Enum> {
        public static final EncodingFormat AUTO = new EncodingFormat(Enum.AUTO, null);
        public static final EncodingFormat MAP_FOOTER_0x0 = new EncodingFormat(Enum.MAP_FOOTER_0x0, (Integer)11);

        @Nullable
        public static EncodingFormat valueOf(@Nonnull Integer version) {
            return EncodingFormat.get(EncodingFormat.class, version);
        }

        private EncodingFormat(@Nonnull Enum enumVal, @Nullable Integer version) {
            super(enumVal, version);
        }

        public static enum Enum {
            AUTO,
            MAP_FOOTER_0x0;

        }
    }
}

