/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.translation.imtranslation;

import de.peeeq.wurstscript.WurstOperator;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.jassIm.ImClass;
import de.peeeq.wurstscript.jassIm.ImExpr;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.ImProg;
import de.peeeq.wurstscript.jassIm.ImStmt;
import de.peeeq.wurstscript.jassIm.ImStmts;
import de.peeeq.wurstscript.jassIm.ImVar;
import de.peeeq.wurstscript.jassIm.ImVars;
import de.peeeq.wurstscript.jassIm.JassIm;
import de.peeeq.wurstscript.translation.imtranslation.ClassManagementVars;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import de.peeeq.wurstscript.translation.imtranslation.RecycleCodeGenerator;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class RecycleCodeGeneratorQueue
implements RecycleCodeGenerator {
    public static boolean setTestMode = false;
    @Nullable
    private Supplier<ImExpr> maxSizeElementFn = null;

    @Override
    public void createAllocFunc(ImTranslator translator, ImProg prog, ImClass c) {
        ImFunction f = translator.allocFunc.getFor(c);
        prog.getFunctions().add(f);
        ImVars locals = f.getLocals();
        ImStmts body = f.getBody();
        Element tr = c.getTrace();
        if (this.maxSizeElementFn == null) {
            Optional<ImVar> maxSizeVar = prog.getGlobals().stream().filter(var -> !setTestMode && var.getName().equals("JASS_MAX_ARRAY_SIZE")).findFirst();
            maxSizeVar.ifPresentOrElse(imVar -> {
                this.maxSizeElementFn = () -> JassIm.ImVarAccess(imVar);
            }, () -> {
                this.maxSizeElementFn = () -> JassIm.ImIntVal(32768);
            });
        }
        ImVar thisVar = JassIm.ImVar(tr, translator.selfType(c), "this", false);
        locals.add(thisVar);
        ClassManagementVars mVars = translator.getClassManagementVarsFor(c);
        ImStmts elseBlock = JassIm.ImStmts(new ImStmt[0]);
        ImStmts thenBlock = JassIm.ImStmts(new ImStmt[0]);
        body.add(JassIm.ImIf(tr, JassIm.ImOperatorCall(WurstOperator.EQ, JassIm.ImExprs(JassIm.ImVarAccess(mVars.freeCount), JassIm.ImIntVal(0))), thenBlock, elseBlock));
        ImStmts ifEnoughMemory = JassIm.ImStmts(new ImStmt[0]);
        ImStmts ifNotEnoughMemory = JassIm.ImStmts(new ImStmt[0]);
        thenBlock.add(JassIm.ImIf(tr, JassIm.ImOperatorCall(WurstOperator.LESS, JassIm.ImExprs(JassIm.ImVarAccess(mVars.maxIndex), this.maxSizeElementFn.get())), ifEnoughMemory, ifNotEnoughMemory));
        ifEnoughMemory.add(JassIm.ImSet(tr, JassIm.ImVarAccess(mVars.maxIndex), JassIm.ImOperatorCall(WurstOperator.PLUS, JassIm.ImExprs(JassIm.ImVarAccess(mVars.maxIndex), JassIm.ImIntVal(1)))));
        ifEnoughMemory.add(JassIm.ImSet(tr, JassIm.ImVarAccess(thisVar), JassIm.ImVarAccess(mVars.maxIndex)));
        ifEnoughMemory.add(JassIm.ImSet(tr, JassIm.ImVarArrayAccess(tr, mVars.typeId, JassIm.ImExprs(JassIm.ImVarAccess(thisVar))), JassIm.ImIntVal(c.attrTypeId())));
        ifNotEnoughMemory.add(translator.imError(c.getTrace(), JassIm.ImStringVal("Out of memory: Could not create " + c.getName() + ".")));
        ifNotEnoughMemory.add(JassIm.ImSet(tr, JassIm.ImVarAccess(thisVar), JassIm.ImIntVal(0)));
        elseBlock.add(JassIm.ImSet(tr, JassIm.ImVarAccess(mVars.freeCount), JassIm.ImOperatorCall(WurstOperator.MINUS, JassIm.ImExprs(JassIm.ImVarAccess(mVars.freeCount), JassIm.ImIntVal(1)))));
        elseBlock.add(JassIm.ImSet(tr, JassIm.ImVarAccess(thisVar), JassIm.ImVarArrayAccess(tr, mVars.free, JassIm.ImExprs(JassIm.ImVarAccess(mVars.freeCount)))));
        elseBlock.add(JassIm.ImSet(tr, JassIm.ImVarArrayAccess(tr, mVars.typeId, JassIm.ImExprs(JassIm.ImVarAccess(thisVar))), JassIm.ImIntVal(c.attrTypeId())));
        body.add(JassIm.ImReturn(tr, JassIm.ImVarAccess(thisVar)));
    }

    @Override
    public void createDeallocFunc(ImTranslator translator, ImProg prog, ImClass c) {
        Element tr = c.getTrace();
        ImFunction f = translator.deallocFunc.getFor(c);
        prog.getFunctions().add(f);
        ImStmts body = f.getBody();
        ImVar thisVar = (ImVar)f.getParameters().get(0);
        ClassManagementVars mVars = translator.getClassManagementVarsFor(c);
        body.add(JassIm.ImIf(tr, JassIm.ImOperatorCall(WurstOperator.EQ, JassIm.ImExprs(JassIm.ImVarArrayAccess(tr, mVars.typeId, JassIm.ImExprs(JassIm.ImVarAccess(thisVar))), JassIm.ImIntVal(0))), JassIm.ImStmts(translator.imError(c.getTrace(), JassIm.ImStringVal("Double free: object of type " + c.getName()))), JassIm.ImStmts(JassIm.ImSet(tr, JassIm.ImVarArrayAccess(tr, mVars.free, JassIm.ImExprs(JassIm.ImVarAccess(mVars.freeCount))), JassIm.ImVarAccess(thisVar)), JassIm.ImSet(tr, JassIm.ImVarAccess(mVars.freeCount), JassIm.ImOperatorCall(WurstOperator.PLUS, JassIm.ImExprs(JassIm.ImVarAccess(mVars.freeCount), JassIm.ImIntVal(1)))), JassIm.ImSet(tr, JassIm.ImVarArrayAccess(tr, mVars.typeId, JassIm.ImExprs(JassIm.ImVarAccess(thisVar))), JassIm.ImIntVal(0)))));
    }
}

