/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.txt.app.jass;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.antlr.JassLexer;
import net.moonlightflower.wc3libs.antlr.LightJassParser;
import net.moonlightflower.wc3libs.txt.app.jass.Decl;
import net.moonlightflower.wc3libs.txt.app.jass.FuncDecl;
import net.moonlightflower.wc3libs.txt.app.jass.FuncImpl;
import net.moonlightflower.wc3libs.txt.app.jass.GlobalVarDecl;
import net.moonlightflower.wc3libs.txt.app.jass.TypeDecl;
import net.moonlightflower.wc3libs.txt.app.jass.VarDecl;
import org.antlr.v4.runtime.Vocabulary;

public class JassScript {
    private List<TypeDecl> _typeDecls = new ArrayList<TypeDecl>();
    private List<VarDecl> _globalVars = new ArrayList<VarDecl>();
    private List<FuncDecl> _nativeDecls = new ArrayList<FuncDecl>();
    private List<FuncImpl> _funcImpls = new ArrayList<FuncImpl>();

    public List<FuncImpl> getFuncImpls() {
        return this._funcImpls;
    }

    public void removeFuncImpl(@Nonnull FuncImpl funcImpl) {
        this._funcImpls.remove(funcImpl);
    }

    public void addFuncImpl(@Nonnull FuncImpl funcImpl) {
        this._funcImpls.add(funcImpl);
    }

    @Nonnull
    public static String getPrimaryLiteral(int tokenType) {
        Vocabulary vocab = JassLexer.VOCABULARY;
        String lit = vocab.getLiteralName(tokenType);
        if (lit == null) {
            return "";
        }
        return lit.replace("'", "");
    }

    public JassScript() {
    }

    public Decl createDecl(@Nonnull LightJassParser.Top_declContext top_declContext) {
        if (top_declContext.type_decl() != null) {
            return TypeDecl.create(top_declContext.type_decl());
        }
        if (top_declContext.native_decl() != null) {
            return FuncDecl.create(top_declContext.native_decl());
        }
        if (top_declContext.globals_block() != null) {
            return GlobalsBlock.create(top_declContext.globals_block());
        }
        if (top_declContext.func_impl() != null) {
            return FuncImpl.create(top_declContext.func_impl());
        }
        throw new AssertionError((Object)("no option for " + top_declContext.getText()));
    }

    public void addDecl(@Nonnull Decl decl) {
        if (decl instanceof TypeDecl) {
            this._typeDecls.add((TypeDecl)decl);
            return;
        }
        if (decl instanceof GlobalsBlock) {
            this._globalVars.addAll(((GlobalsBlock)decl)._varDecls);
            return;
        }
        if (decl instanceof FuncDecl) {
            this._nativeDecls.add((FuncDecl)decl);
            return;
        }
        if (decl instanceof FuncImpl) {
            this._funcImpls.add((FuncImpl)decl);
            return;
        }
        throw new AssertionError((Object)("no option for " + decl));
    }

    public JassScript(@Nonnull LightJassParser.RootContext rootContext) {
        for (LightJassParser.Top_declContext top_declContext : rootContext.top_decl()) {
            Decl decl = this.createDecl(top_declContext);
            this.addDecl(decl);
        }
    }

    public void write(@Nonnull StringWriter sw, boolean isLua) {
        for (TypeDecl typeDecl : this._typeDecls) {
            typeDecl.write(sw, isLua);
            sw.write("\n");
        }
        for (FuncDecl nativeDecl : this._nativeDecls) {
            nativeDecl.write(sw, isLua);
            sw.write("\n");
        }
        sw.write(JassScript.getPrimaryLiteral(25));
        sw.write("\n");
        for (VarDecl varDecl : this._globalVars) {
            varDecl.write(sw, isLua);
            sw.write("\n");
        }
        sw.write(JassScript.getPrimaryLiteral(26));
        sw.write("\n");
        for (FuncImpl funcImpl : this._funcImpls) {
            funcImpl.write(sw, isLua);
            sw.write("\n");
        }
    }

    private static class GlobalsBlock
    implements Decl {
        private final List<VarDecl> _varDecls = new ArrayList<VarDecl>();

        public GlobalsBlock(@Nonnull List<VarDecl> varDecls) {
            this._varDecls.addAll(varDecls);
        }

        public static GlobalsBlock create(@Nonnull LightJassParser.Globals_blockContext globals_blockContext) {
            ArrayList<VarDecl> varDecls = new ArrayList<VarDecl>();
            for (LightJassParser.Global_declContext global_declContext : globals_blockContext.global_decl()) {
                varDecls.add(GlobalVarDecl.create(global_declContext));
            }
            return new GlobalsBlock(varDecls);
        }

        @Override
        public void write(@Nonnull StringWriter sw, boolean isLua) {
            sw.write(JassScript.getPrimaryLiteral(25));
            sw.write("\n");
            for (VarDecl varDecl : this._varDecls) {
                varDecl.write(sw, isLua);
                sw.write("\n");
            }
            sw.write(JassScript.getPrimaryLiteral(26));
        }
    }
}

