/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc.image;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.MemoryCacheImageInputStream;
import net.moonlightflower.wc3libs.dataTypes.app.FlagsInt;
import net.moonlightflower.wc3libs.misc.Size;
import net.moonlightflower.wc3libs.misc.UnsupportedFormatException;
import net.moonlightflower.wc3libs.misc.image.FxImg;
import net.moonlightflower.wc3libs.misc.image.Wc3RasterImg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BLP
extends Wc3RasterImg {
    private static final Logger log = LoggerFactory.getLogger((String)FlagsInt.class.getName());

    private void read(@Nonnull InputStream inStream) throws UnsupportedFormatException {
        try {
            int n;
            Reader reader = new Reader(inStream);
            String startToken = reader.readChar4();
            int version = startToken.charAt(3) - 48;
            int type = reader.readInt();
            boolean hasAlpha = false;
            if (version >= 2) {
                int pixmapType = reader.readUByte();
                if (pixmapType > 3) {
                    throw new UnsupportedFormatException(String.format("invalid pixmapType %d", pixmapType));
                }
                byte alphaBits = reader.readByte();
                byte sampleType = reader.readByte();
                n = reader.readByte();
            } else {
                int alphaBits = reader.readInt();
                hasAlpha = (alphaBits & 8) > 0;
            }
            int width = reader.readInt();
            int height = reader.readInt();
            if (width > 512) {
                throw new UnsupportedFormatException(String.format("width %d exceeds the limit of 512", width));
            }
            if (height > 512) {
                throw new UnsupportedFormatException(String.format("height %d exceeds the limit of 512", height));
            }
            if (version < 2) {
                int unknown = reader.readInt();
                n = reader.readInt();
            }
            int[] mipmapOffsets = new int[16];
            int[] mipmapSizes = new int[16];
            if (version >= 1) {
                int i;
                for (i = 0; i < 16; ++i) {
                    mipmapOffsets[i] = reader.readInt();
                }
                for (i = 0; i < 16; ++i) {
                    mipmapSizes[i] = reader.readInt();
                }
            }
            switch (type) {
                case 0: {
                    int headerSize = reader.readInt();
                    byte[] headerBytes = new byte[headerSize];
                    for (int i = 0; i < headerSize; ++i) {
                        headerBytes[i] = reader.readByte();
                    }
                    byte[][] mipmapDatas = new byte[16][];
                    for (int i = 0; i < 16; ++i) {
                        reader.seek(mipmapOffsets[i]);
                        byte[] mipmapData = new byte[mipmapSizes[i]];
                        mipmapDatas[i] = mipmapData;
                        for (int j = 0; j < mipmapSizes[i]; ++j) {
                            mipmapData[j] = reader.readByte();
                        }
                    }
                    ByteBuffer buf = ByteBuffer.allocate(headerSize + mipmapSizes[0]);
                    buf.put(headerBytes);
                    buf.put(mipmapDatas[0]);
                    ByteArrayInputStream stream = new ByteArrayInputStream(buf.array());
                    ((InputStream)stream).reset();
                    Iterator<ImageReader> imgReaders = ImageIO.getImageReadersByFormatName("jpeg");
                    ImageReader imgReader = null;
                    while (imgReaders.hasNext() && !(imgReader = imgReaders.next()).canReadRaster()) {
                        imgReader = null;
                    }
                    if (imgReader == null) {
                        throw new AssertionError((Object)"found no suitable reader");
                    }
                    MemoryCacheImageInputStream imageInputStream = new MemoryCacheImageInputStream(stream);
                    imgReader.setInput(imageInputStream, true, true);
                    ImageReadParam readParam = imgReader.getDefaultReadParam();
                    readParam.setDestinationBands(new int[]{2, 1, 0, 3});
                    Raster raster = imgReader.readRaster(0, readParam);
                    imgReader.dispose();
                    BufferedImage writeImg = new BufferedImage(raster.getWidth(), raster.getHeight(), 2);
                    for (int x = 0; x < raster.getWidth(); ++x) {
                        for (int y = 0; y < raster.getHeight(); ++y) {
                            int[] colors = new int[4];
                            raster.getPixel(x, y, colors);
                            int red = colors[2];
                            int green = colors[1];
                            int blue = colors[0];
                            int alpha = 255;
                            Color color = new Color(red, green, blue, alpha);
                            writeImg.setRGB(x, y, color.getRGB());
                        }
                    }
                    this.setFXImg(new FxImg(writeImg));
                    break;
                }
                case 1: {
                    byte[][] colors = new byte[256][4];
                    for (int i = 0; i < 256; ++i) {
                        colors[i][0] = reader.readByte();
                        colors[i][1] = reader.readByte();
                        colors[i][2] = reader.readByte();
                        colors[i][3] = reader.readByte();
                    }
                    int curWidth = width;
                    int curHeight = height;
                    byte[][] mipmapIndexLists = new byte[16][];
                    byte[][] mipmapAlphaLists = new byte[16][];
                    for (int i = 0; i < 1; ++i) {
                        byte[] indexList = new byte[curWidth * curHeight];
                        mipmapIndexLists[i] = indexList;
                        for (int j = 0; j < indexList.length; ++j) {
                            indexList[j] = reader.readByte();
                        }
                        if (!hasAlpha) continue;
                        byte[] alphaList = new byte[curWidth * curHeight];
                        mipmapAlphaLists[i] = alphaList;
                        for (int j = 0; j < indexList.length; ++j) {
                            alphaList[j] = reader.readByte();
                        }
                    }
                    BufferedImage writeImg = new BufferedImage(width, height, 2);
                    int c = 0;
                    byte[] indexList = mipmapIndexLists[0];
                    byte[] alphaList = mipmapAlphaLists[0];
                    for (int y = 0; y < height; ++y) {
                        for (int x = 0; x < width; ++x) {
                            int colIndex = indexList[c] & 0xFF;
                            double red = (double)(colors[colIndex][2] & 0xFF) / 255.0;
                            double green = (double)(colors[colIndex][1] & 0xFF) / 255.0;
                            double blue = (double)(colors[colIndex][0] & 0xFF) / 255.0;
                            double alpha = 1.0;
                            if (hasAlpha) {
                                int alphaIndex = alphaList[c] & 0xFF;
                                alpha = (double)(alphaIndex & 0xFF) / 255.0;
                            }
                            writeImg.setRGB(x, y, new Color((int)(red * 255.0), (int)(green * 255.0), (int)(blue * 255.0), (int)(alpha * 255.0)).getRGB());
                            ++c;
                        }
                    }
                    this.setFXImg(new FxImg(writeImg));
                    break;
                }
                default: {
                    throw new UnsupportedFormatException(String.format("format type %d not supported", type));
                }
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public BLP(@Nonnull InputStream inStream) throws UnsupportedFormatException {
        this.read(inStream);
    }

    public BLP(@Nonnull File file) throws IOException, UnsupportedFormatException {
        InputStream inStream = Files.newInputStream(file.toPath(), new OpenOption[0]);
        this.read(inStream);
        inStream.close();
    }

    public BLP(@Nonnull Size size) {
        super(size);
    }

    private static class Reader {
        private byte[] _bytes;
        private int _pos;

        public byte[] read(int size) {
            byte[] b = new byte[size];
            for (int i = 0; i < size; ++i) {
                b[i] = this._bytes[this._pos];
                ++this._pos;
            }
            return b;
        }

        public byte readByte() {
            return this.read(1)[0];
        }

        public int readUByte() {
            return this.readByte() & 0xFF;
        }

        public int readInt() {
            ByteBuffer buf = ByteBuffer.wrap(this.read(4));
            buf.order(ByteOrder.LITTLE_ENDIAN);
            return buf.getInt();
        }

        public String readChar4() {
            byte[] bytes = this.read(4);
            return new String(bytes);
        }

        public void seek(int val) {
            this._pos = val;
        }

        public Reader(@Nonnull InputStream inStream) throws IOException {
            int val;
            ArrayList<Byte> bytes = new ArrayList<Byte>();
            while ((val = inStream.read()) != -1) {
                bytes.add((byte)(val & 0xFF));
            }
            this._bytes = new byte[bytes.size()];
            for (int i = 0; i < bytes.size(); ++i) {
                this._bytes[i] = (Byte)bytes.get(i);
            }
        }
    }
}

