/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.frotty.jassAttributes;

import com.google.common.collect.Maps;
import de.peeeq.wurstscript.frotty.jassValidator.JassErrors;
import de.peeeq.wurstscript.jassAst.Element;
import de.peeeq.wurstscript.jassAst.JassArrayVar;
import de.peeeq.wurstscript.jassAst.JassExprVarRef;
import de.peeeq.wurstscript.jassAst.JassFunction;
import de.peeeq.wurstscript.jassAst.JassProgs;
import de.peeeq.wurstscript.jassAst.JassStmtSet;
import de.peeeq.wurstscript.jassAst.JassStmtSetArray;
import de.peeeq.wurstscript.jassAst.JassVar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;

public class VariableDefinition {
    public static @Nullable JassVar get(JassExprVarRef e) {
        String varName = e.getVarName();
        for (Element node = e.getParent(); node != null; node = node.getParent()) {
            JassProgs jassProgs;
            JassFunction jassFunction;
            JassVar v;
            if (!(node instanceof JassFunction ? (v = VariableDefinition.getVariableMap(jassFunction = (JassFunction)node).get(varName)) != null : node instanceof JassProgs && (v = (jassProgs = (JassProgs)node).getGlobal(varName)) != null)) continue;
            return v;
        }
        JassErrors.addError("Could not find variable '" + varName + "'.", e.getLine());
        return null;
    }

    public static Map<String, JassVar> getVariableMap(JassFunction f) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        VariableDefinition.addVarsToMap(result, f.getLocals());
        VariableDefinition.addVarsToMap(result, f.getParams());
        return result;
    }

    private static void addVarsToMap(Map<String, JassVar> result, List<? extends JassVar> vs) {
        for (JassVar jassVar : vs) {
            JassVar oldVar = result.put(jassVar.getName(), jassVar);
            if (oldVar == null) continue;
            JassErrors.addError("Variable '" + jassVar.getName() + "' is already declared in line " + oldVar.getLine() + ".", jassVar.getLine());
        }
    }

    public static @Nullable JassStmtSet get(JassStmtSet e) {
        String varName = e.getLeft();
        for (Element node = e.getParent(); node != null; node = node.getParent()) {
            JassVar v = null;
            if (node instanceof JassFunction) {
                JassFunction jassFunction = (JassFunction)node;
                v = VariableDefinition.getVariableMap(jassFunction).get(varName);
            } else if (node instanceof JassProgs) {
                JassProgs jassProgs = (JassProgs)node;
                v = jassProgs.getGlobal(varName);
            }
            if (v == null) continue;
            if (v instanceof JassArrayVar) {
                JassErrors.addError("Variable '" + varName + "' is declared as an array.", e.getLine());
                return null;
            }
            return e;
        }
        JassErrors.addError("Could not find variable '" + varName + "'.", e.getLine());
        return null;
    }

    public static @Nullable JassStmtSetArray get(JassStmtSetArray e) {
        String varName = e.getLeft();
        for (Element node = e.getParent(); node != null; node = node.getParent()) {
            JassProgs jassProgs;
            JassFunction jassFunction;
            JassVar v;
            if (!(node instanceof JassFunction ? (v = VariableDefinition.getVariableMap(jassFunction = (JassFunction)node).get(varName)) != null && v instanceof JassArrayVar : node instanceof JassProgs && (v = (jassProgs = (JassProgs)node).getGlobal(varName)) != null && v instanceof JassArrayVar)) continue;
            return e;
        }
        JassErrors.addError("Could not find variable '" + varName + "'.", e.getLine());
        return null;
    }
}

