/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.txt.app.jass.expr.bool;

import java.io.StringWriter;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.antlr.JassParser;
import net.moonlightflower.wc3libs.txt.app.jass.expr.bool.BoolExpr;
import net.moonlightflower.wc3libs.txt.app.jass.expr.bool.Relation;
import net.moonlightflower.wc3libs.txt.app.jass.expr.num.NumExpr;

public class NumRelation
extends Relation<NumExpr, Op> {
    private NumExpr _left;
    private Op _op;
    private NumExpr _right;

    public NumRelation(@Nonnull NumExpr left, @Nonnull Op op, @Nonnull NumExpr right) {
        super(left, op, right);
        this._left = left;
        this._op = op;
        this._right = right;
    }

    public static Op createOp(@Nonnull JassParser.Bool_num_order_relation_opContext bool_num_order_relation_opContext) {
        return ((Function<JassParser.Bool_num_order_relation_opContext, Op>)bool_num_order_relation_opContext1 -> {
            if (bool_num_order_relation_opContext1.LESS() != null) {
                return Op.LESS;
            }
            if (bool_num_order_relation_opContext1.LESS_EQUAL() != null) {
                return Op.LESS_EQUAL;
            }
            if (bool_num_order_relation_opContext1.GREATER() != null) {
                return Op.GREATER;
            }
            if (bool_num_order_relation_opContext1.GREATER_EQUAL() != null) {
                return Op.GREATER_EQUAL;
            }
            throw new AssertionError((Object)("no option for " + bool_num_order_relation_opContext1.getText()));
        }).apply(bool_num_order_relation_opContext);
    }

    public static Op createNumOp(@Nonnull JassParser.Bool_relation_opContext bool_relation_opContext) {
        return ((Function<JassParser.Bool_relation_opContext, Op>)bool_relation_opContext1 -> {
            if (bool_relation_opContext1.EQUAL() != null) {
                return Op.EQUAL;
            }
            if (bool_relation_opContext1.UNEQUAL() != null) {
                return Op.UNEQUAL;
            }
            throw new AssertionError((Object)("no option for " + bool_relation_opContext1.getText()));
        }).apply(bool_relation_opContext);
    }

    public static BoolExpr create(@Nonnull JassParser.Num_exprContext left, @Nonnull JassParser.Bool_num_order_relation_opContext bool_num_order_relation_opContext, @Nonnull JassParser.Num_exprContext right) {
        return new NumRelation(NumExpr.create(left), NumRelation.createOp(bool_num_order_relation_opContext), NumExpr.create(right));
    }

    public static BoolExpr create(@Nonnull JassParser.Num_exprContext left, @Nonnull JassParser.Bool_relation_opContext bool_relation_opContext, @Nonnull JassParser.Num_exprContext right) {
        return new NumRelation(NumExpr.create(left), NumRelation.createNumOp(bool_relation_opContext), NumExpr.create(right));
    }

    @Override
    public void write(@Nonnull StringWriter sw) {
        this._left.write(sw);
        switch (this._op) {
            case EQUAL: {
                sw.write("=");
                break;
            }
            case UNEQUAL: {
                sw.write("!=");
                break;
            }
            case LESS: {
                sw.write("<");
                break;
            }
            case LESS_EQUAL: {
                sw.write("<=");
                break;
            }
            case GREATER: {
                sw.write(">");
                break;
            }
            case GREATER_EQUAL: {
                sw.write(">=");
                break;
            }
            default: {
                throw new AssertionError((Object)("no option for " + this._op));
            }
        }
        this._right.write(sw);
    }

    public static enum Op implements Relation.IOp
    {
        EQUAL{

            @Override
            public void write(@Nonnull StringWriter sw) {
                sw.write("=");
            }
        }
        ,
        UNEQUAL{

            @Override
            public void write(@Nonnull StringWriter sw) {
                sw.write("!=");
            }
        }
        ,
        LESS{

            @Override
            public void write(@Nonnull StringWriter sw) {
                sw.write("<");
            }
        }
        ,
        LESS_EQUAL{

            @Override
            public void write(@Nonnull StringWriter sw) {
                sw.write("<=");
            }
        }
        ,
        GREATER{

            @Override
            public void write(@Nonnull StringWriter sw) {
                sw.write(">");
            }
        }
        ,
        GREATER_EQUAL{

            @Override
            public void write(@Nonnull StringWriter sw) {
                sw.write(">=");
            }
        };

    }
}

