/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.slk.app.terrainArts;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.dataTypes.DataList;
import net.moonlightflower.wc3libs.dataTypes.DataType;
import net.moonlightflower.wc3libs.dataTypes.DataTypeInfo;
import net.moonlightflower.wc3libs.dataTypes.app.TileId;
import net.moonlightflower.wc3libs.dataTypes.app.War3Bool;
import net.moonlightflower.wc3libs.dataTypes.app.War3Int;
import net.moonlightflower.wc3libs.dataTypes.app.War3String;
import net.moonlightflower.wc3libs.misc.FieldId;
import net.moonlightflower.wc3libs.misc.ObjId;
import net.moonlightflower.wc3libs.slk.ObjSLK;
import net.moonlightflower.wc3libs.slk.RawSLK;
import net.moonlightflower.wc3libs.slk.SLK;
import net.moonlightflower.wc3libs.slk.SLKState;

public class TerrainSLK
extends ObjSLK<TerrainSLK, TileId, Obj> {
    public static final File GAME_PATH = new File("TerrainArt\\Terrain.slk");

    @Override
    @Nonnull
    public Map<TileId, Obj> getObjs() {
        return this._objs;
    }

    @Override
    public void addObj(@Nonnull Obj val) {
        this._objs.put((TileId)val.getId(), val);
    }

    @Override
    @Nonnull
    public Obj addObj(@Nonnull TileId id) {
        if (this._objs.containsKey(id)) {
            return (Obj)this._objs.get(id);
        }
        Obj obj = new Obj(id);
        this.addObj(obj);
        return obj;
    }

    public RawSLK toRawSLK() {
        RawSLK slk = new RawSLK();
        for (Obj obj : this.getObjs().values()) {
            Object id = obj.getId();
            Object slkObj = slk.addObj(id);
            ((SLK.Obj)slkObj).merge(obj, true);
        }
        return slk;
    }

    @Override
    protected void read(@Nonnull SLK<?, ? extends ObjId, ? extends SLK.Obj<? extends ObjId>> slk) {
        for (Map.Entry<? extends ObjId, ? extends SLK.Obj<? extends ObjId>> slkEntry : slk.getObjs().entrySet()) {
            ObjId id = slkEntry.getKey();
            SLK.Obj<? extends ObjId> slkObj = slkEntry.getValue();
            Obj obj = new Obj(slkObj);
            this.addObj(obj);
        }
    }

    @Override
    public void read(@Nonnull File file) throws IOException {
        this.read(new RawSLK(file));
    }

    @Override
    public void write(@Nonnull File file) throws IOException {
        this.toRawSLK().write(file);
    }

    public TerrainSLK() {
        this.addField(State.OBJ_ID);
        for (State state : State.values(State.class)) {
            this.addField(state);
        }
    }

    @Override
    @Nonnull
    public Obj createObj(@Nonnull ObjId id) {
        return new Obj(TileId.valueOf(id));
    }

    @Override
    public void merge(@Nonnull TerrainSLK other, boolean overwrite) {
    }

    public static class Obj
    extends SLK.Obj<TileId> {
        private final Map<State, DataType> _stateVals = new LinkedHashMap<State, DataType>();

        @Override
        public Map<State, DataType> getStateVals() {
            return new LinkedHashMap<State, DataType>(this._stateVals);
        }

        @Override
        protected void on_set(@Nonnull FieldId fieldId, @Nullable DataType val) {
            State state = (State)State.valueByField(State.class, fieldId);
            if (state != null) {
                this._stateVals.put(state, val);
            }
        }

        @Override
        protected void on_remove(@Nonnull FieldId fieldId) {
            State state = (State)State.valueByField(State.class, fieldId);
            if (state != null) {
                this._stateVals.remove(state);
            }
        }

        @Override
        protected void on_clear() {
            this._stateVals.clear();
        }

        public Path getTex() {
            return Paths.get(this.get(State.ART_TEX_DIR).toString(), this.get(State.ART_TEX_FILE).toString());
        }

        public void setTex(Path val) {
            this.set(State.ART_TEX_DIR, War3String.valueOf(val.getParent().toString()));
            this.set(State.ART_TEX_FILE, War3String.valueOf(val.getFileName().toString()));
        }

        public War3Int getCliffSet() {
            return this.get(State.DATA_CLIFF_SET);
        }

        public void setCliffSet(War3Int val) {
            this.set(State.DATA_CLIFF_SET, val);
        }

        public War3Bool getWalkable() {
            return this.get(State.DATA_WALKABLE);
        }

        public void setWalkable(War3Bool val) {
            this.set(State.DATA_WALKABLE, val);
        }

        public War3Bool getFlyable() {
            return this.get(State.DATA_FLYABLE);
        }

        public void setFlyable(War3Bool val) {
            this.set(State.DATA_FLYABLE, val);
        }

        public War3Bool getBuildable() {
            return this.get(State.DATA_BUILDABLE);
        }

        public void setBuildable(War3Bool val) {
            this.set(State.DATA_BUILDABLE, val);
        }

        public War3Bool getFootprints() {
            return this.get(State.ART_FOOTPRINTS);
        }

        public void setFootprints(War3Bool val) {
            this.set(State.ART_FOOTPRINTS, val);
        }

        public War3Int getBlightPrio() {
            return this.get(State.DATA_BLIGHT_PRIO);
        }

        public void setBlightPrio(War3Int val) {
            this.set(State.DATA_BLIGHT_PRIO, val);
        }

        public <T extends DataType> T get(State<T> state) {
            return (T)super.get(state);
        }

        public <T extends DataType> void set(State<T> state, T val) {
            super.set(state, val);
        }

        public <T extends DataType> void remove(State<T> state) {
            super.set(state, null);
        }

        private void read(SLK.Obj slkObj) {
            this.merge(slkObj, true);
        }

        public Obj(SLK.Obj slkObj) {
            super(TileId.valueOf(slkObj.getId()));
            this.read(slkObj);
        }

        public Obj(TileId id) {
            super(id);
            for (State state : State.values(State.class)) {
                this.set((SLKState)state, (DataType)state.getDefVal());
            }
        }

        @Override
        public void reduce() {
        }
    }

    public static class State<T extends DataType>
    extends ObjSLK.State<T> {
        public static final State<TileId> OBJ_ID = new State<TileId>("tileID", TileId.class);
        public static final State<War3Bool> ART_FOOTPRINTS = new State<War3Bool>("footprints", War3Bool.class);
        public static final State<War3String> ART_TEX_DIR = new State<War3String>("dir", War3String.class);
        public static final State<War3String> ART_TEX_FILE = new State<War3String>("file", War3String.class);
        public static final State<War3Int> DATA_BLIGHT_PRIO = new State<War3Int>("blightPri", War3Int.class);
        public static final State<War3Bool> DATA_BUILDABLE = new State<War3Bool>("buildable", War3Bool.class);
        public static final State<War3Int> DATA_CLIFF_SET = new State<War3Int>("cliffSet", War3Int.class);
        public static final State<DataList<TileId>> DATA_CONVERT_TO = new State("convertTo", new DataTypeInfo((Class<? extends DataType>)DataList.class, (Class<? extends DataType>)TileId.class));
        public static final State<War3Bool> DATA_FLYABLE = new State<War3Bool>("flyable", War3Bool.class);
        public static final State<War3Bool> DATA_WALKABLE = new State<War3Bool>("walkable", War3Bool.class);
        public static final State<War3String> EDITOR_COMMENT = new State<War3String>("comment", War3String.class);
        public static final State<War3Bool> EDITOR_IN_BETA = new State<War3Bool>("InBeta", War3Bool.class);
        public static final State<War3Int> EDITOR_VERSION = new State<War3Int>("version", War3Int.class);

        public State(String idString, DataTypeInfo typeInfo, T defVal) {
            super(idString, typeInfo, defVal);
        }

        public State(String idString, DataTypeInfo typeInfo) {
            super(idString, typeInfo);
        }

        public State(String idString, Class<T> type) {
            super(idString, type);
        }

        public State(String idString, Class<T> type, T defVal) {
            super(idString, type, defVal);
        }
    }
}

