/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.port;

import java.io.File;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.port.GameDirFinder;
import net.moonlightflower.wc3libs.port.NotFoundException;
import net.moonlightflower.wc3libs.port.Orient;
import net.moonlightflower.wc3libs.port.mac.MacGameDirFinder;
import net.moonlightflower.wc3libs.port.win.WinGameDirFinder;

public class StdGameDirFinder
extends GameDirFinder {
    protected GameDirFinder getMacGameDirFinder() {
        return new MacGameDirFinder();
    }

    protected GameDirFinder getWinGameDirFinder() {
        return new WinGameDirFinder();
    }

    @Override
    @Nonnull
    public File find() throws NotFoundException {
        File envWar3Dir;
        String envWar3DirS = System.getenv("war3dir");
        if (envWar3DirS != null && (envWar3Dir = new File(envWar3DirS)).exists()) {
            return envWar3Dir;
        }
        if (Orient.isMacSystem()) {
            GameDirFinder macGameDirFinder = this.getMacGameDirFinder();
            return (File)macGameDirFinder.get();
        }
        if (Orient.isWindowsSystem()) {
            GameDirFinder winGameDirFinder = this.getWinGameDirFinder();
            return (File)winGameDirFinder.get();
        }
        throw new NotFoundException(new Exception("system not supported: " + Orient.getSystem()));
    }
}

