/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.dataTypes.app.War3String;
import net.moonlightflower.wc3libs.misc.FieldId;
import net.moonlightflower.wc3libs.misc.Printable;
import net.moonlightflower.wc3libs.misc.Printer;
import net.moonlightflower.wc3libs.txt.TXT;
import net.moonlightflower.wc3libs.txt.TXTSectionId;

public class Translator
implements Printable {
    private final TXT _txt = this.createTXT();

    protected TXT createTXT() {
        return new TXT();
    }

    @Nonnull
    public TXT getTXT() {
        return this._txt;
    }

    public boolean contains(@Nonnull String key) {
        return this._txt.containsKey(FieldId.valueOf(key));
    }

    public boolean contains(@Nonnull String sectionName, @Nonnull String key) {
        TXT.Section section = this._txt.getSection(TXTSectionId.valueOf(sectionName));
        return section != null && section.containsField(FieldId.valueOf(key));
    }

    @Nullable
    public String get(@Nonnull String key) {
        try {
            return this._txt.get(FieldId.valueOf(key)).toString();
        }
        catch (TXT.Section.FieldDoesNotExistException fieldDoesNotExistException) {
            return null;
        }
    }

    @Nullable
    public String get(@Nonnull String sectionName, @Nonnull String fieldName) {
        TXT.Section section = this._txt.getSection(TXTSectionId.valueOf(sectionName));
        if (section == null) {
            return null;
        }
        try {
            return section.get(FieldId.valueOf(fieldName)).toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void set(@Nonnull String key, @Nonnull String val) {
        this._txt.set(FieldId.valueOf(key), War3String.valueOf(val));
    }

    @Nullable
    public String translate(@Nonnull String key) {
        if (this.contains(key)) {
            return this.get(key);
        }
        return key;
    }

    @Nullable
    public String translate(@Nonnull String sectionName, @Nonnull String val) {
        if (this.contains(sectionName, val)) {
            return this.get(sectionName, val);
        }
        return val;
    }

    @Nullable
    public String translateText(@Nonnull String text) {
        return text;
    }

    public void addTXT(@Nonnull TXT other) {
        this._txt.merge(other);
    }

    public void addDataTypeTXT(@Nonnull TXT txt) {
        TXT other = new TXT();
        for (Map.Entry<TXTSectionId, TXT.Section> sectionEntry : txt.getSections().entrySet()) {
            TXTSectionId sectionId = sectionEntry.getKey();
            TXT.Section section = sectionEntry.getValue();
            TXT.Section otherSection = other.addSection(sectionId);
            for (Map.Entry<FieldId, ? extends TXT.Section.Field> fieldEntry : section.getFields().entrySet()) {
                FieldId fieldId = fieldEntry.getKey();
                TXT.Section.Field field = fieldEntry.getValue();
                if (!field.getId().toString().matches("^\\d+$")) continue;
                String dataName = field.get(0).toString();
                String displayName = field.get(1).toString();
                TXT.Section.Field otherField = otherSection.addField(FieldId.valueOf(dataName));
                otherField.set(War3String.valueOf(displayName));
            }
        }
        this.addTXT(other);
    }

    @Override
    public void print(@Nonnull Printer printer) {
        this._txt.print(printer);
    }
}

