/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.dataTypes.app;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.dataTypes.DataType;
import net.moonlightflower.wc3libs.dataTypes.app.War3Real;

public class Coords2DF
extends DataType {
    private final War3Real _x;
    private final War3Real _y;

    @Nonnull
    public War3Real getX() {
        return this._x;
    }

    @Nonnull
    public War3Real getY() {
        return this._y;
    }

    public boolean equals(Object other) {
        if (other instanceof Coords2DF) {
            return this.equals((Coords2DF)other);
        }
        return super.equals(other);
    }

    public boolean equals(Coords2DF other) {
        return this.getX().equals(other.getX()) && this.getY().equals(other.getY());
    }

    public String toString() {
        return String.format("%s;%s", this.getX(), this.getY());
    }

    @Nonnull
    public Coords2DF scale(double factor) {
        double x = (double)this.getX().toFloat() * factor;
        double y = (double)this.getY().toFloat() * factor;
        return new Coords2DF((int)x, (int)y);
    }

    public Coords2DF(float x, float y) {
        this._x = War3Real.valueOf(x);
        this._y = War3Real.valueOf(y);
    }

    public Coords2DF(@Nonnull War3Real x, @Nonnull War3Real y) {
        this(x.toFloat(), y.toFloat());
    }

    public int hashCode() {
        int result = this._x != null ? this._x.hashCode() : 0;
        result = 31 * result + (this._y != null ? this._y.hashCode() : 0);
        return result;
    }

    @Override
    public DataType decode(Object val) {
        return null;
    }

    public static DataType decodeStatic(Object val) {
        if (val instanceof Coords2DF) {
            return new Coords2DF(((Coords2DF)val).getX(), ((Coords2DF)val).getY());
        }
        return null;
    }

    @Override
    public Object toSLKVal() {
        return null;
    }

    @Override
    public Object toTXTVal() {
        return null;
    }

    public Coords2DF squish() {
        return new Coords2DF(Objects.requireNonNull(War3Real.valueOf(Math.floor(this._x.getVal().floatValue() * 1000.0f) / 1000.0)), Objects.requireNonNull(War3Real.valueOf(Math.floor(this._y.getVal().floatValue() * 1000.0f) / 1000.0)));
    }
}

